/*
 * Decompiled with CFR 0.152.
 */
package org.zergle.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.zergle.json.JsonObject;
import org.zergle.json.lex.JsonParser;
import org.zergle.lex.SyntaxError;

public class JsonReader
extends Reader {
    private JsonParser parser;
    private Reader reader;

    public JsonReader(Reader reader) {
        super((Object)reader);
        this.reader = reader;
        this.parser = new JsonParser(reader);
    }

    public JsonReader(InputStream in) {
        this(new InputStreamReader(in));
    }

    public JsonReader(InputStream in, String charsetName) throws UnsupportedEncodingException {
        this(new InputStreamReader(in, charsetName));
    }

    public JsonReader(InputStream in, Charset charset) {
        this(new InputStreamReader(in, charset));
    }

    public final JsonObject readJsonObject() throws IOException, SyntaxError {
        return this.parser.parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.reader.read(cbuf, off, len);
        }
    }
}

