/*
 * Decompiled with CFR 0.152.
 */
package org.zergle.json;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.zergle.io.OutputFormat;
import org.zergle.json.JsonObject;

public class JsonWriter
extends Writer {
    private Writer out;

    public JsonWriter(Writer writer) {
        super((Object)writer);
        this.out = writer;
    }

    public JsonWriter(OutputStream out) {
        this(new OutputStreamWriter(out));
    }

    public JsonWriter(OutputStream out, String charsetName) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(out, charsetName));
    }

    public JsonWriter(OutputStream out, Charset charset) {
        this(new OutputStreamWriter(out, charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(JsonObject json, OutputFormat format) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out != null) {
                if (format == null) {
                    this.out.write(json.toJsonString());
                } else {
                    this.out.write(((Object)format.format(json)).toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out != null) {
                this.out.write(cbuf, off, len);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out != null) {
                this.out.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out != null) {
                this.out.close();
            }
        }
    }
}

