/*
 * Decompiled with CFR 0.152.
 */
package org.zergle.json.lex;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.zergle.json.lex.JsonConstant;
import org.zergle.json.lex.JsonTokenType;
import org.zergle.lex.AbstractLexer;
import org.zergle.lex.Token;

public final class JsonLexer
extends AbstractLexer
implements JsonConstant {
    public JsonLexer(Reader reader) {
        super(reader);
    }

    public JsonLexer(InputStream is, String charsetName) throws UnsupportedEncodingException {
        this(new InputStreamReader(is, charsetName));
    }

    public JsonLexer(InputStream is, Charset charset) throws UnsupportedEncodingException {
        this(new InputStreamReader(is, charset));
    }

    @Override
    public Token next() throws IOException {
        Token t;
        block12: {
            t = null;
            try {
                this.skipWhite();
                char c = this.read();
                this.stack.push(c);
                if (JsonLexer.isDigit(c)) {
                    if (c == '0') {
                        c = this.read();
                        this.stack.push(c);
                        if (c == 'x' || c == 'X') {
                            t = this.readHex();
                        } else if (JsonLexer.isOctal(c)) {
                            t = this.readOctal();
                        } else if (JsonLexer.isDigit(c)) {
                            t = this.readDecimal();
                        } else {
                            this.unread(this.stack.pop());
                            t = this.createToken(JsonTokenType.NUMBER);
                        }
                    } else {
                        t = this.readDecimal();
                    }
                } else {
                    t = JsonLexer.isIdentifier(c) && !JsonLexer.isDigit(c) ? this.readIdentifier() : this.readOther();
                }
            }
            catch (EOFException e) {
                if (this.reader == null) break block12;
                this.reader.close();
                this.reader = null;
            }
        }
        return t;
    }

    @Override
    protected Token createToken(Enum<?> type) {
        Token t = super.createToken(type);
        if (JsonLexer.isKeyWord(t.image)) {
            t.type = JsonTokenType.KEYWORD;
        }
        return t;
    }

    private Token readOctal() throws IOException {
        char c = '\u0000';
        while (JsonLexer.isOctal(c = this.read())) {
            this.stack.push(c);
        }
        this.unread(c);
        return this.createToken(JsonTokenType.NUMBER);
    }

    private Token readDecimal() throws IOException {
        char c = '\u0000';
        int p = -1;
        while (true) {
            if (!JsonLexer.isDigit(c = this.read())) {
                if (c == '.') {
                    if (this.stack.indexOf(c) != -1) {
                        this.unread(c);
                        break;
                    }
                } else if (c == 'e' || c == 'E') {
                    if (this.stack.indexOf('e') != -1 || this.stack.indexOf('E') != -1) {
                        this.unread(c);
                        break;
                    }
                } else if (c == '+' || c == '-') {
                    if (p != 101 && p != 69) {
                        this.unread(c);
                    }
                } else {
                    this.unread(c);
                    break;
                }
            }
            this.stack.push(c);
            p = c;
        }
        return this.createToken(JsonTokenType.NUMBER);
    }

    private Token readHex() throws IOException {
        char c = '\u0000';
        while (JsonLexer.isHex(c = this.read())) {
            this.stack.push(c);
        }
        this.unread(c);
        return this.createToken(JsonTokenType.NUMBER);
    }

    private Token readIdentifier() throws IOException {
        char c = '\u0000';
        while (JsonLexer.isIdentifier(c = this.read())) {
            this.stack.push(c);
        }
        this.unread(c);
        return this.createToken(JsonTokenType.ID);
    }

    private Token readString() throws IOException {
        char p;
        char c = '\u0000';
        char quote = p = this.stack.peek();
        while ((quote != (c = this.read()) || p == '\\') && c != '\r' && c != '\n') {
            p = c;
            this.stack.push(c);
        }
        this.stack.push(c);
        return this.createToken(JsonTokenType.STRING);
    }

    private Token readOther() throws IOException {
        char c = this.stack.peek();
        switch (c) {
            case '{': {
                return this.createToken(JsonTokenType.LBRACE);
            }
            case '}': {
                return this.createToken(JsonTokenType.RBRACE);
            }
            case '[': {
                return this.createToken(JsonTokenType.LBRACKET);
            }
            case ']': {
                return this.createToken(JsonTokenType.RBRACKET);
            }
            case '(': {
                return this.createToken(JsonTokenType.LPAREN);
            }
            case ')': {
                return this.createToken(JsonTokenType.RPAREN);
            }
            case '\"': 
            case '\'': {
                return this.readString();
            }
            case ':': {
                return this.createToken(JsonTokenType.COLON);
            }
            case ',': {
                return this.createToken(JsonTokenType.COMMA);
            }
            case ';': {
                return this.createToken(JsonTokenType.SEMICOLON);
            }
            case '\\': {
                return this.createToken(JsonTokenType.BACKSLASH);
            }
            case '+': {
                return this.createToken(JsonTokenType.PLUS);
            }
            case '-': {
                c = this.read();
                if (JsonLexer.isDigit(c)) {
                    this.unread(c);
                    return this.next();
                }
                this.unread(c);
                return this.createToken(JsonTokenType.MINUS);
            }
            case '*': {
                return this.createToken(JsonTokenType.MULTIPLY);
            }
            case '/': {
                c = this.read();
                if (c == '/') {
                    this.stack.clear();
                    c = this.read();
                    while (c != '\r' && c != '\n') {
                        c = this.read();
                    }
                    return this.next();
                }
                if (c == '*') {
                    this.stack.clear();
                    while (this.read() != '*' || this.read() != '/') {
                    }
                    return this.next();
                }
                this.unread(c);
                return this.createToken(JsonTokenType.DIVID);
            }
            case '>': {
                c = this.read();
                if (c == '=') {
                    return this.createToken(JsonTokenType.GET);
                }
                this.unread(c);
                return this.createToken(JsonTokenType.GT);
            }
            case '<': {
                c = this.read();
                if (c == '=') {
                    return this.createToken(JsonTokenType.LET);
                }
                this.unread(c);
                return this.createToken(JsonTokenType.LT);
            }
            case '=': {
                c = this.read();
                if (c == '=') {
                    return this.createToken(JsonTokenType.LET);
                }
                this.unread(c);
                return this.createToken(JsonTokenType.ASSIGN);
            }
            case '.': {
                c = this.read();
                if (JsonLexer.isDigit(c)) {
                    this.stack.push(c);
                    return this.readDecimal();
                }
                this.unread(c);
                return this.createToken(JsonTokenType.DOT);
            }
        }
        return this.createToken(JsonTokenType.UNDEFINED);
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean isOctal(char c) {
        return c >= '0' && c <= '7';
    }

    private static boolean isIdentifier(char c) {
        return Character.isLetter(c) || JsonLexer.isDigit(c) || c == '_' || c == '$';
    }

    private static boolean isKeyWord(String word) {
        return KEYWORDS.contains(word);
    }
}

