/*
 * Decompiled with CFR 0.152.
 */
package org.zergle.json.lex;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import org.zergle.json.JsonArray;
import org.zergle.json.JsonBoolean;
import org.zergle.json.JsonNumber;
import org.zergle.json.JsonObject;
import org.zergle.json.JsonString;
import org.zergle.json.lex.JsonConstant;
import org.zergle.json.lex.JsonLexer;
import org.zergle.json.lex.JsonTokenType;
import org.zergle.lex.AbstractParser;
import org.zergle.lex.SyntaxError;

public final class JsonParser
extends AbstractParser
implements JsonConstant {
    public JsonParser(Reader reader) {
        this(new JsonLexer(reader));
    }

    public JsonParser(JsonLexer lexer) {
        super(lexer);
    }

    @Override
    public JsonObject parse() throws IOException, SyntaxError {
        if (this.lexer.hasNext()) {
            this.currToken = this.lexer.next();
            JsonTokenType type = (JsonTokenType)this.currToken.type;
            switch (type) {
                case MINUS: 
                case PLUS: {
                    if (this.lexer.hasNext()) {
                        this.currToken = this.lexer.next();
                        if (this.currToken.type == JsonTokenType.NUMBER) {
                            return this.parseNumber();
                        }
                        if ("Infinity".equals(this.currToken.image)) {
                            type = (JsonTokenType)this.currToken.previous.type;
                            switch (type) {
                                case MINUS: {
                                    return JsonNumber.NEGATIVE_INFINITY;
                                }
                                case PLUS: {
                                    return JsonNumber.POSITIVE_INFINITY;
                                }
                            }
                        } else if ("NaN".equals(this.currToken.image)) {
                            return JsonNumber.NAN;
                        }
                    }
                    throw this.invalidToken();
                }
                case LBRACE: {
                    return this.parseObject();
                }
                case LBRACKET: {
                    return this.parseArray();
                }
                case NUMBER: {
                    if ("Infinity".equals(this.currToken.image)) {
                        return JsonNumber.POSITIVE_INFINITY;
                    }
                    if ("-Infinity".equals(this.currToken.image)) {
                        return JsonNumber.NEGATIVE_INFINITY;
                    }
                    return new JsonNumber(this.currToken.image);
                }
                case STRING: {
                    return this.parseString();
                }
                case KEYWORD: {
                    String word = this.currToken.image.trim();
                    if ("true".equals(word)) {
                        return new JsonBoolean(true);
                    }
                    if ("false".equals(word)) {
                        return new JsonBoolean(false);
                    }
                    if ("null".equals(word) || "undifined".equals(word)) {
                        return JsonObject.NULL;
                    }
                    if ("NaN".equals(word)) {
                        return JsonObject.NAN;
                    }
                    throw this.invalidToken();
                }
            }
            throw this.invalidToken();
        }
        return JsonObject.NULL;
    }

    private JsonObject parseObject() throws IOException {
        HashMap<String, JsonObject> map = new HashMap<String, JsonObject>();
        block7: while (this.lexer.hasNext()) {
            this.currToken = this.lexer.next();
            JsonTokenType type = (JsonTokenType)this.currToken.type;
            switch (type) {
                case ID: {
                    this.currToken = this.lexer.next();
                    if (this.currToken == null || this.currToken.type != JsonTokenType.COLON) {
                        throw this.expectToken(":");
                    }
                    map.put(this.currToken.previous.image, this.parse());
                    if (this.lexer.hasNext()) {
                        this.currToken = this.lexer.next();
                        type = (JsonTokenType)this.currToken.type;
                        switch (type) {
                            case RBRACE: {
                                return new JsonObject(map);
                            }
                            case COMMA: {
                                continue block7;
                            }
                        }
                        throw this.invalidToken();
                    }
                    throw this.expectToken("}");
                }
            }
            throw this.expectToken("identifier");
        }
        throw this.expectToken("}");
    }

    private JsonArray parseArray() throws IOException {
        JsonArray json = new JsonArray();
        block12: while (this.lexer.hasNext()) {
            this.currToken = this.lexer.next();
            JsonTokenType type = (JsonTokenType)this.currToken.type;
            switch (type) {
                case RBRACKET: {
                    return json;
                }
                case COMMA: {
                    type = (JsonTokenType)this.currToken.previous.type;
                    switch (type) {
                        case LBRACKET: 
                        case COMMA: {
                            json.add(JsonObject.NULL);
                        }
                    }
                    continue block12;
                }
                case LBRACE: {
                    json.add(this.parseObject());
                    continue block12;
                }
                case LBRACKET: {
                    json.add(this.parseArray());
                    continue block12;
                }
                case NUMBER: {
                    json.add(this.parseNumber());
                    continue block12;
                }
                case STRING: {
                    json.add(this.parseString());
                    continue block12;
                }
                case KEYWORD: {
                    String word = this.currToken.image.trim();
                    if ("true".equals(word)) {
                        json.add(JsonBoolean.TRUE);
                        break;
                    }
                    if ("false".equals(word)) {
                        json.add(JsonBoolean.FALSE);
                        break;
                    }
                    if ("null".equals(word) || "undifined".equals(word)) {
                        json.add(JsonObject.NULL);
                        break;
                    }
                    throw this.invalidToken();
                }
            }
            throw this.invalidToken();
        }
        return null;
    }

    private JsonString parseString() {
        String img = this.currToken.image;
        if (img.startsWith("\"")) {
            if (!img.endsWith("\"")) {
                throw this.expectToken("\"");
            }
        } else if (img.startsWith("'") && !img.endsWith("'")) {
            throw this.expectToken("'");
        }
        return new JsonString(img.substring(1, img.length() - 1));
    }

    private JsonNumber parseNumber() {
        return new JsonNumber(this.currToken.image);
    }

    private SyntaxError invalidToken() {
        return new SyntaxError("invalid token " + this.currToken.image + " at line " + this.currToken.line + ", column " + this.currToken.column);
    }

    private SyntaxError expectToken(String token) {
        return new SyntaxError("expect " + token + " at line " + this.currToken.line + ", column " + (this.currToken.column + this.currToken.image.length() + 1));
    }
}

