/*
 * Decompiled with CFR 0.152.
 */
package org.zergle.json.utils;

import java.util.Enumeration;
import java.util.Iterator;
import org.zergle.json.JsonArray;
import org.zergle.json.utils.JsonConverter;

public class ArrayConverter
implements JsonConverter<JsonArray> {
    @Override
    public JsonArray convert(Object object) {
        if (object instanceof byte[]) {
            byte[] b = (byte[])object;
            return new JsonArray(b);
        }
        if (object instanceof char[]) {
            char[] c = (char[])object;
            return new JsonArray(c);
        }
        if (object instanceof short[]) {
            short[] s = (short[])object;
            return new JsonArray(s);
        }
        if (object instanceof int[]) {
            int[] i = (int[])object;
            return new JsonArray(i);
        }
        if (object instanceof long[]) {
            long[] l = (long[])object;
            return new JsonArray(l);
        }
        if (object instanceof float[]) {
            float[] f = (float[])object;
            return new JsonArray(f);
        }
        if (object instanceof double[]) {
            double[] d = (double[])object;
            return new JsonArray(d);
        }
        if (object instanceof boolean[]) {
            boolean[] b = (boolean[])object;
            return new JsonArray(b);
        }
        if (object.getClass().isArray()) {
            return new JsonArray((Object[])object);
        }
        if (object instanceof Iterable) {
            return new JsonArray((Iterable)object);
        }
        if (object instanceof Enumeration) {
            return new JsonArray((Enumeration)object);
        }
        if (object instanceof Iterator) {
            return new JsonArray((Iterator)object);
        }
        return new JsonArray();
    }

    @Override
    public Class<?>[] getAcceptTypes() {
        return new Class[]{byte[].class, char[].class, short[].class, int[].class, long[].class, float[].class, double[].class, boolean[].class, Object[].class, Iterable.class, Enumeration.class, Iterator.class};
    }
}

