/*
 * Decompiled with CFR 0.152.
 */
package org.zergle.json.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.zergle.json.JsonObject;
import org.zergle.json.utils.JsonConverter;

public class DateConverter
implements JsonConverter<JsonObject> {
    @Override
    public JsonObject convert(Object object) {
        Calendar c = null;
        HashMap<String, Integer> date = new HashMap<String, Integer>();
        if (object instanceof Date) {
            c = Calendar.getInstance();
            c.setTime((Date)object);
        } else if (object instanceof Calendar) {
            c = (Calendar)object;
        }
        if (c != null) {
            date.put("year", c.get(1));
            date.put("month", c.get(2));
            date.put("date", c.get(5));
            date.put("hour12", c.get(10));
            date.put("hour24", c.get(11));
            date.put("minute", c.get(12));
            date.put("second", c.get(13));
            date.put("millisecond", c.get(14));
            date.put("dayOfWeek", c.get(7));
            date.put("dayOfMonth", c.get(5));
            date.put("dayOfWeekInMonth", c.get(8));
            date.put("dateOfYear", c.get(6));
            date.put("weekOfMonth", c.get(4));
            date.put("weekOfYear", c.get(3));
            date.put("", c.get(9));
            return new JsonObject(date);
        }
        return JsonObject.NULL;
    }

    @Override
    public Class<?>[] getAcceptTypes() {
        return new Class[]{Date.class, Calendar.class};
    }
}

