/*
 * Decompiled with CFR 0.152.
 */
package org.zergle.json.utils;

import java.util.Iterator;
import org.zergle.io.OutputFormat;
import org.zergle.json.JsonArray;
import org.zergle.json.JsonObject;

public class JsonOutputFormat
implements OutputFormat {
    @Override
    public CharSequence format(Object object) {
        StringBuffer buff = new StringBuffer();
        this.format(buff, object, 0);
        return buff;
    }

    private void format(StringBuffer buff, Object object, int level) {
        if (object.getClass().equals(JsonObject.class)) {
            JsonObject json = JsonObject.valueOf(object);
            this.formatJsonObject(buff, json, level);
        } else if (object.getClass().equals(JsonArray.class)) {
            JsonArray json = (JsonArray)JsonObject.valueOf(object);
            this.formatJsonArray(buff, json, level);
        } else if (object instanceof JsonObject) {
            JsonObject json = (JsonObject)object;
            buff.append(json);
        } else {
            JsonObject json = JsonObject.valueOf(object);
            buff.append(this.format(json));
        }
    }

    private void formatJsonObject(StringBuffer buff, JsonObject json, int level) {
        buff.append("{").append(this.getLineFeed());
        Iterator<CharSequence> iterator = json.getPropertyNames();
        while (iterator.hasNext()) {
            CharSequence property = iterator.next();
            JsonObject jsonObject = json.get(property);
            this.indent(buff, level + 1);
            if (!JsonObject.isIdentifier(property)) {
                buff.append("\"").append(property).append("\"");
            } else {
                buff.append(property);
            }
            buff.append(" : ");
            this.format(buff, jsonObject, level + 1);
            if (!iterator.hasNext()) continue;
            buff.append(",").append(this.getLineFeed());
        }
        buff.append(this.getLineFeed());
        this.indent(buff, level);
        buff.append("}");
    }

    private void formatJsonArray(StringBuffer buff, JsonArray json, int level) {
        buff.append("[").append(this.getLineFeed());
        Iterator<JsonObject> iterator = json.elements().iterator();
        while (iterator.hasNext()) {
            JsonObject jsonObject = iterator.next();
            this.indent(buff, level + 1);
            this.format(buff, jsonObject, level + 1);
            if (!iterator.hasNext()) continue;
            buff.append(",").append(this.getLineFeed());
        }
        buff.append(this.getLineFeed());
        this.indent(buff, level);
        buff.append("]");
    }

    private void indent(StringBuffer buff, int level) {
        for (int i = 0; i < level * this.getIndentSize(); ++i) {
            buff.append(this.getIndentChar());
        }
    }

    @Override
    public CharSequence getLineFeed() {
        return "\r\n";
    }

    @Override
    public char getIndentChar() {
        return ' ';
    }

    @Override
    public int getIndentSize() {
        return 4;
    }
}

