/*
 * Decompiled with CFR 0.152.
 */
package org.zergle.lex;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.zergle.lex.Token;
import org.zergle.utils.CharStack;

public abstract class AbstractLexer {
    protected static int BUFF_SIZE = 255;
    protected int line = 1;
    protected int column = 1;
    protected boolean isCR;
    protected boolean isLF;
    protected CharStack stack = new CharStack();
    protected PushbackReader reader;
    protected Token currToken;

    public AbstractLexer(Reader reader) {
        this.reader = new PushbackReader(new BufferedReader(reader), BUFF_SIZE);
    }

    public AbstractLexer(InputStream is) {
        this(new InputStreamReader(is));
    }

    public AbstractLexer(InputStream is, String charsetName) throws UnsupportedEncodingException {
        this(new InputStreamReader(is, charsetName));
    }

    public AbstractLexer(InputStream is, Charset charset) {
        this(new InputStreamReader(is, charset));
    }

    public boolean hasNext() {
        try {
            this.skipWhite();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public abstract Token next() throws IOException;

    protected char read() throws IOException {
        int c = -1;
        if (this.reader == null || (c = this.reader.read()) == -1) {
            throw new EOFException();
        }
        switch (c) {
            case 10: 
            case 13: {
                this.isLF = true;
                this.isCR = c == 13;
                this.column = 1;
                if (this.isCR && this.isLF) break;
                ++this.line;
                break;
            }
            default: {
                ++this.column;
                this.isCR = false;
                this.isLF = false;
            }
        }
        return (char)c;
    }

    protected void unread(char c) throws IOException {
        this.reader.unread(c);
        switch (c) {
            case '\n': 
            case '\r': {
                this.column = 1;
                break;
            }
            default: {
                this.column = this.column < 1 ? 1 : this.column - 1;
            }
        }
    }

    protected String dumpStack() {
        String image = this.stack.toString();
        this.stack.clear();
        return image;
    }

    protected void skipWhite() throws IOException {
        char c = this.read();
        if (c == '\uffffffff') {
            return;
        }
        while (Character.isWhitespace((int)c)) {
            c = this.read();
            if (c != '\uffffffff') continue;
            return;
        }
        this.unread(c);
    }

    protected Token createToken(Enum<?> type) {
        String image = this.dumpStack();
        Token token = new Token(this.line, this.column - image.length(), type, image);
        token.previous = this.currToken;
        if (this.currToken != null) {
            this.currToken.next = token;
        }
        this.currToken = token;
        return token;
    }
}

