/*
 * Decompiled with CFR 0.152.
 */
package org.zergle.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Beans {
    private Beans() {
    }

    public static String[] getPropertyNames(Class<?> clazz) {
        String[] properties = null;
        PropertyDescriptor[] pds = Beans.getPropertyDescriptors(clazz);
        properties = new String[pds.length];
        for (int i = 0; i < pds.length; ++i) {
            properties[i] = pds[i].getName();
        }
        return properties;
    }

    public static Method getter(Class<?> clazz, String propertyName) {
        PropertyDescriptor[] pds = Beans.getPropertyDescriptors(clazz);
        for (int i = 0; i < pds.length; ++i) {
            if (!pds[i].getName().equals(propertyName)) continue;
            return pds[i].getReadMethod();
        }
        return null;
    }

    public static Method setter(Class<?> clazz, String propertyName) {
        PropertyDescriptor[] pds = Beans.getPropertyDescriptors(clazz);
        for (int i = 0; i < pds.length; ++i) {
            if (!pds[i].getName().equals(propertyName)) continue;
            return pds[i].getWriteMethod();
        }
        return null;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            return beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object clone(Object object) throws IOException, ClassNotFoundException {
        if (object instanceof Serializable) {
            ByteArrayOutputStream baos = null;
            ByteArrayInputStream bais = null;
            ObjectOutputStream oos = null;
            ObjectInputStream ois = null;
            try {
                baos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(baos);
                oos.writeObject(object);
                oos.flush();
                baos.flush();
                bais = new ByteArrayInputStream(baos.toByteArray());
                ois = new ObjectInputStream(bais);
                Object object2 = ois.readObject();
                return object2;
            }
            finally {
                try {
                    if (oos != null) {
                        oos.close();
                        oos = null;
                    }
                    if (baos != null) {
                        baos.close();
                        baos = null;
                    }
                    if (ois != null) {
                        ois.close();
                        ois = null;
                    }
                    if (bais != null) {
                        bais.close();
                        bais = null;
                    }
                }
                catch (IOException e) {}
            }
        }
        throw new NotSerializableException();
    }

    public static Object getProperty(Object object, String propertyName) throws IllegalAccessException, InvocationTargetException {
        Method getter = Beans.getter(object.getClass(), propertyName);
        if (getter != null) {
            return getter.invoke(object, new Object[0]);
        }
        return null;
    }

    public static void setProperty(Object object, String propertyName, Object value) throws IllegalAccessException, InvocationTargetException {
        Method setter = Beans.setter(object.getClass(), propertyName);
        if (setter != null) {
            setter.invoke(object, value);
        }
    }
}

