/*
 * Decompiled with CFR 0.152.
 */
package org.zergle.utils;

import org.zergle.utils.EmptyQueueException;

public class CharQueue {
    private Entry header;
    private int size;

    public char peek() throws EmptyQueueException {
        if (this.size == 0) {
            throw new EmptyQueueException();
        }
        return this.header.value;
    }

    public void offer(int c) {
        this.offer((char)c);
    }

    public void offer(char c) {
        ++this.size;
        if (this.header == null) {
            this.header.next = this.header.previous = (this.header = new Entry(null, null, c));
        } else {
            Entry entry;
            this.header.previous.next = entry = new Entry(this.header.previous, this.header, c);
            this.header.previous = entry;
        }
    }

    public char poll() throws EmptyQueueException {
        char c = this.peek();
        Entry newHeader = this.header.next;
        newHeader.previous = this.header.previous;
        newHeader.previous.next = newHeader;
        this.header = newHeader;
        --this.size;
        return c;
    }

    public int indexOf(char c) {
        Entry entry = this.header;
        for (int i = 0; i < this.size; ++i) {
            if (entry.value == c) {
                return i;
            }
            entry = entry.next;
        }
        return -1;
    }

    public int indexOf(int c) {
        return this.indexOf((char)c);
    }

    public void clear() {
        this.size = 0;
        this.header = null;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        char[] buf = new char[this.size];
        Entry entry = this.header;
        for (int i = 0; i < this.size; ++i) {
            buf[i] = entry.value;
            entry = entry.next;
        }
        return new String(buf);
    }

    private class Entry {
        Entry previous;
        Entry next;
        char value;

        Entry(Entry previous, Entry next) {
            this(previous, next, '\uffff');
        }

        Entry(Entry previous, Entry next, char c) {
            this.previous = previous;
            this.next = next;
            this.value = c;
        }
    }
}

