/*
 * Decompiled with CFR 0.152.
 */
package org.zergle.utils;

import java.util.EmptyStackException;

public final class CharStack {
    private char[] buffer;
    private int size;

    public CharStack() {
        this(10);
    }

    public CharStack(int capacity) throws IllegalArgumentException {
        if (capacity < 0) {
            throw new IllegalArgumentException("stack capacity " + capacity + " lower than 0");
        }
        this.size = 0;
        this.buffer = new char[capacity];
    }

    public void push(char c) {
        this.ensureCapacity();
        this.buffer[this.size++] = c;
    }

    public void push(int c) {
        this.push((char)c);
    }

    public char pop() throws EmptyStackException {
        char c = this.peek();
        this.buffer[this.size--] = '\u0000';
        return c;
    }

    public char peek() throws EmptyStackException {
        try {
            return this.buffer[this.size - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new EmptyStackException();
        }
    }

    public int size() {
        return this.size;
    }

    public char get(int index) throws IndexOutOfBoundsException {
        return this.buffer[index];
    }

    public int indexOf(char c) {
        for (int i = 0; i < this.size; ++i) {
            if (this.buffer[i] != c) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(int c) {
        return this.indexOf((char)c);
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public void clear() {
        this.size = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCapacity() {
        char[] cArray = this.buffer;
        synchronized (this.buffer) {
            if (this.size >= this.buffer.length - 1) {
                char[] buffer = new char[this.buffer.length << 1];
                System.arraycopy(this.buffer, 0, buffer, 0, this.buffer.length);
                this.buffer = buffer;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        return new String(this.buffer, 0, this.size);
    }
}

