/*
 * Decompiled with CFR 0.152.
 */
package org.zergle.utils;

public class Platform {
    private Platform() {
    }

    public static boolean isWindows() {
        return Platform.getOSName().matches(".*(?i)Windows.*");
    }

    public static boolean isUnix() {
        return Platform.getOSName().matches(".*(?i)Unix.*");
    }

    public static boolean isLinux() {
        return Platform.getOSName().matches(".*(?i)Linux.*");
    }

    public static boolean isMac() {
        return Platform.getOSName().matches(".*(?i)Mac.*");
    }

    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static String getOSVersion() {
        return System.getProperty("os.version");
    }

    public static String getUserDir() {
        return System.getProperty("user.dir");
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static String getJavaHome() {
        return System.getProperty("java.home");
    }

    public static String getFileEncoding() {
        return System.getProperty("file.encoding");
    }

    public static String getExtDirs() {
        return System.getProperty("java.ext.dirs");
    }
}

