/*
 * Decompiled with CFR 0.152.
 */
package org.zergle.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class PropertiesLoader {
    private static final Iterator<String> EMPTY_ITERATOR = new EmptyIterator();
    private final Properties prop = new Properties();

    public PropertiesLoader(InputStream is) throws IOException {
        this(new InputStreamReader(is));
    }

    public PropertiesLoader(Reader reader) throws IOException {
        this.prop.load(reader);
    }

    public PropertiesLoader(String name) throws IOException {
        this(PropertiesLoader.class.getResourceAsStream(name));
    }

    public String lookup(String key) {
        return this.prop.getProperty(key);
    }

    public void set(String key, String value) {
        this.prop.setProperty(key, value);
    }

    public void save(OutputStream os) throws IOException {
        this.prop.store(os, "");
    }

    public String lookup(String key, String defaultValue) {
        return this.prop.getProperty(key, defaultValue);
    }

    public Iterator<String> propertyNames() {
        Set<Object> keys = this.prop.keySet();
        if (keys != null) {
            final Iterator<Object> keyIt = keys.iterator();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return keyIt.hasNext();
                }

                @Override
                public String next() {
                    return String.valueOf(keyIt.next());
                }

                @Override
                public void remove() {
                }
            };
        }
        return EMPTY_ITERATOR;
    }

    public int getInt(String key) throws NumberFormatException {
        return Integer.parseInt(this.lookup(key, "0"));
    }

    public float getFloat(String key) throws NumberFormatException {
        return Float.parseFloat(this.lookup(key, "0"));
    }

    public boolean getBoolean(String key) {
        return new Boolean(this.lookup(key, "false"));
    }

    private static final class EmptyIterator
    implements Iterator<String> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public String next() {
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

