/*
 * Decompiled with CFR 0.152.
 */
package org.zergle.utils;

import org.zergle.Filter;

public class Text {
    private Text() {
    }

    public static String cap(String str) {
        char[] literals = str.toCharArray();
        boolean beCap = true;
        for (int i = 0; i < literals.length; ++i) {
            if (beCap) {
                if (Character.isLowerCase(literals[i])) {
                    int n = i;
                    literals[n] = (char)(literals[n] - 32);
                }
            } else if (Character.isUpperCase(literals[i])) {
                int n = i;
                literals[n] = (char)(literals[n] + 32);
            }
            beCap = !Character.isLetter(literals[i]);
        }
        return new String(literals);
    }

    public static CharSequence escape(CharSequence str) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            buff.append(Text.escape(c));
        }
        return buff;
    }

    public static CharSequence escape(CharSequence str, Filter<Character> filter) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            buff.append(filter.accept(Character.valueOf(c)) ? Text.escape(c) : Character.valueOf(c));
        }
        return buff;
    }

    public static CharSequence escape(char c) {
        StringBuffer buff = new StringBuffer();
        switch (c) {
            case '/': {
                buff.append("\\/");
                break;
            }
            case '\"': {
                buff.append("\\\"");
                break;
            }
            case '\\': {
                buff.append("\\\\");
                break;
            }
            case '\b': {
                buff.append("\\b");
                break;
            }
            case '\r': {
                buff.append("\\r");
                break;
            }
            case '\n': {
                buff.append("\\n");
                break;
            }
            case '\t': {
                buff.append("\\t");
                break;
            }
            case '\f': {
                buff.append("\\f");
                break;
            }
            default: {
                buff.append(c);
            }
        }
        return buff;
    }

    public static String unicode(CharSequence str) {
        StringBuffer buff = new StringBuffer();
        char[] unicode = new char[]{'\\', 'u', '0', '0', '0', '0'};
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            String hex = Integer.toHexString(c).toUpperCase();
            for (int j = 0; j < hex.length(); ++j) {
                unicode[6 - hex.length() + j] = hex.charAt(j);
            }
            buff.append(unicode);
        }
        return buff.toString();
    }
}

