/*
 * Decompiled with CFR 0.152.
 */
package org.zergle.utils;

import java.util.LinkedList;
import java.util.Queue;

public class ThreadPool
extends ThreadGroup {
    private boolean closed = true;
    private final int size;
    private Queue<Runnable> tasks;

    public ThreadPool(String id) {
        this(id, 10);
    }

    public ThreadPool(String id, int size) {
        super(id);
        this.size = size;
        this.setDaemon(true);
    }

    public synchronized void init() {
        this.tasks = new LinkedList<Runnable>();
        for (int i = 0; i < this.size; ++i) {
            Worker w = new Worker();
            w.start();
        }
        this.closed = false;
    }

    public synchronized void execute(Runnable task) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("ThreadPool is closed!");
        }
        this.tasks.offer(task);
        this.notify();
    }

    public synchronized void close() {
        if (!this.isClosed()) {
            this.readyForClose();
            this.tasks.clear();
            this.interrupt();
        }
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    private synchronized Runnable getTask(Worker w) throws InterruptedException {
        while (this.tasks.isEmpty()) {
            if (this.isClosed()) {
                return null;
            }
            this.wait();
        }
        return this.tasks.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readyForClose() {
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.closed = true;
            this.notifyAll();
        }
        Thread[] threads = new Thread[this.activeCount()];
        int count = this.enumerate(threads);
        for (int i = 0; i < count; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private class Worker
    extends Thread {
        private Worker() {
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Runnable task = ThreadPool.this.getTask(this);
                    if (task == null) continue;
                    task.run();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

