;(function($){
    var Dialog = function(e, options){
        /** 选项 */
        options = options || {};
        this.el = e;
        this.showShade = (undefined === options.showShade ? true : options.showShade);
        this.showTime=  options.showTime || 1000;
        this.module = options.module || "data-dialog";
        this.bgColor = options.bgColor || "#000";
        this.bgOpacity = options.bgOpacity || 0.7;
        this.clickClose = (undefined === options.clickClose ? true : options.clickClose);

        /** 组件 */
        this.dialog = this._createDialog();

        this.shade = this._createShade(this.bgColor);
        if(!this.showShade){
            this.bgOpacity = 0;
            this.bgColor = "transparent";
        }

        /** 变量 */
        this.STEP = 20;

        var self = this;

        /** 事件绑定 */
        this.el.on('click', function(){ self.toggle(); });
        if(this.clickClose){
            this.shade.on('click', function(){ self.hide(); });
        }
        this.dialog.find(".accept").on("click", function(){ self.hide(); self.accept(); });
        this.dialog.find(".reject").on("click", function(){ self.hide(); self.reject(); });
        $(window).on('resize', function(){ self._resizeEvent(); });
        return self;
    };

    /** protected */
    Dialog.prototype._resizeEvent = function(){
        var self = this;
        if(!self.dialog){
            console.error("Where are your components!?");
            return ;
        }

        var windowWidth = $(window).width();
        var windowHeight = $(window).height();
        var width = self.dialog.width();
        var height = self.dialog.height();

        self.dialog.css("left", (windowWidth / 2) - (width / 2));
        self.dialog.css("top", (windowHeight / 2) - (height / 2));
    }

    /** protected */
    Dialog.prototype._createShade = function(bgColor){
        var _shade = $("<div><!-- <div> -->").appendTo("body");
        _shade.css("background-color", bgColor);
        _shade.css("opacity", 0);
        _shade.css("top", "0");
        _shade.css("width", "100%");
        _shade.css("height", "100%");
        _shade.css("position", "fixed");
        _shade.css("display", "none");
        _shade.css("z-index", 99);

        return _shade;
    }

    /** protectd */
    Dialog.prototype._createDialog = function(){
        var self = this;
        var _dialog = $("#" + self.el.attr(self.module));
        _dialog.css("display", "none");
        _dialog.css("position", "fixed");
        _dialog.css("z-index", 100);
        _dialog.css("opacity", 0);

        return _dialog;
    }

    /** public */
    Dialog.prototype.toggle = function(){
        var self = this;
        if("none" === self.dialog.css("display")){
            self.dialog.show();
            self._resizeEvent();
            self.show();
        }
        else{
            self.hide();
        }
        return self;
    };

    /** public */
    Dialog.prototype.show = function(){
        var self = this;
        var CHIPS = self.showTime / self.STEP;
        var OPACITY_STEP = parseFloat((1.0 * self.bgOpacity) / CHIPS);
        self.shade.css("display", "block");

        (function start(time){
            time -= self.STEP;

            if(0 >= time){
                self.dialog.css("display", "block");
                self.dialog.css("opacity", 1);
                self.shade.css("opacity", self.bgOpacity);
                return ;
            }

            if(!this.showShade){
                var opacity = parseFloat(self.shade.css("opacity"));
                opacity += OPACITY_STEP;
                self.shade.css("opacity", opacity);
            }

            var opacity = parseFloat(self.dialog.css("opacity"));
            opacity += parseFloat(1.0 / CHIPS);
            self.dialog.css("opacity", opacity);
            window.setTimeout(function(){
                start(time);
            }, self.STEP);
        })(self.showTime);
        return self;
    };

    /** public */
    Dialog.prototype.hide = function(){
        var self = this;
        var CHIPS = self.showTime / self.STEP;
        var OPACITY_STEP = parseFloat((1.0 * self.bgOpacity) / CHIPS);

        (function start(time){
            time -= self.STEP;

            if(0 >= time){
                self.dialog.hide();
                self.dialog.css("opacity", 0);
                self.shade.hide();
                self.shade.css("opacity", 0);
                return ;
            }

            if(!this.showShade){
                var opacity = parseFloat(self.shade.css("opacity"));
                opacity -= OPACITY_STEP;
                self.shade.css("opacity", opacity);
            }

            var opacity = parseFloat(self.dialog.css("opacity"));
            opacity -= parseFloat(1.0 / CHIPS);
            self.dialog.css("opacity", opacity);
            window.setTimeout(function(){
                start(time);
            }, self.STEP);
        })(self.showTime);

        return self;
    };

    /** public */
    Dialog.prototype.accept = function(callback){
        var self = this;
        self.accept = callback;
        return self;
    }

    /** public */
    Dialog.prototype.reject = function(callback){
        var self = this;
        self.reject = callback
        return self;
    }

    $.extend($.fn, {
        dialog: function(opts){
            var dialog = new Dialog(this, opts);
            return dialog;
        }
    });
})(window.Zepto || window.jQuery);

;(function($){
    var XGAuthDialog = function(dialog){
        dialog = dialog || "#loginDialog";
        if("string" === typeof(dialog)){
            dialog = $(dialog);
        }
        this.dialog = dialog;
        this.dialog.css("z-index", 999);
        this.dialog.css("position", "fixed");
        this.dialog.css("top", 0);
        this.dialog.css("left", 0);
        this.dialog.css("width", "100%");
        this.dialog.css("height", "100%");

        var self = this;
        self.dialog.find(".closable").on("click", function(){
            self.hide();
            self.doCancelLogin && self.doCancelLogin();
        });

        self.dialog.find(".accept").on("click", function(){
            self._startLogin();
        });

        return this;
    };

    XGAuthDialog.prototype._startLogin = function(){
        var username = $.trim($("#un").val());
        var password = $.trim($("#pwd").val());

        if("" === username || undefined === username){
            alert("用户名不能为空");
            return false;
        }
        if("" === password || undefined === password){
            alert("密码不能为空");
            return false;
        }

        var data = {};
        data.un = username;
        data.password = password;

        this.doAfterLogin = this.doAfterLogin || function(){};

        $.ajax("", data, this.doAfterLogin);
    }

    XGAuthDialog.prototype.show = function(){
        this.dialog.show();
        return this;
    }

    XGAuthDialog.prototype.hide = function(){
        this.dialog.hide();
        return this;
    }

    XGAuthDialog.prototype.afterLogin = function(callback){
        this.doAfterLogin = callback;
        return this;
    }

    XGAuthDialog.prototype.cancelLogin = function(callback){
        this.doCancalLogin = callback;
        return this;
    }

    $.extend($, {
        AuthDialog: function(selector){
            return new XGAuthDialog(selector);
        }
    });
})(window.Zepto || window.jQuery);

/** 打开HTML静态方法 */
function openDialog(id){
    var dialog = $(id);
    var shade = $("<div></div>").appendTo($("body"));
    shade.css("position", "fixed");
    shade.css("background-color", "rgba(0,0,0,.7)");
    shade.css("top", 0);
    shade.css("left", 0);
    shade.css("width", "100%");
    shade.css("height", "100%");
    shade.css("z-index", 9);
    shade.show();
    dialog.find(".reject").on("click", function(){
        dialog.find(".reject").off("click");
        dialog.hide();
        shade.remove();
        window.onresize = function(){};
    });
    dialog.show();
    _xgresize(dialog);
    window.onresize = function(){
        _xgresize(dialog);
    }
}

function closeDialog(id){
    var dialog = $(id);
    dialog.hide();
}

function _xgresize(div){
    var winWidth = $(window).width();
    var winHeight = $(window).height();
    var width = div.width();
    var height = div.height();

    div.css("position", "fixed");
    div.css("margin-left", "auto");
    div.css("margin-right", "auto");
    div.css("top", (winHeight - height) / 2);
    div.css("left", (winWidth - width) / 2);
}
