/**
 * 胜负平发起合买
 * 前端交互实现
 */
$(function(){
    "use strict";

    /** 公开方式 */
    $("#lottery-public").on("click", selectPublic);
    
    /** 点击提成之后 */
    $("#deduct-list .deduct-btn").on("click", selectDeduct);

    /** 发起合买 */
    $("#submit").on("click", submit);

    /** 是否需要提成 */
    $("#c").on("change", isDeduct);

    /** 选择公开方式 */
    function selectPublic(e){
        var btn = $(e.target);
        var btns = $("#lottery-public .btn.btn-radius-h");
        btns.each(function(){
            $(this).removeClass("checked");
        });
        btn.addClass("checked");
    }

    /* 选择提成 */
    function selectDeduct(e){
        var btn = $(e.target);
        var deductCheck = $("#c");
        /* 如果关闭提成，则不选择 */
        if(!deductCheck.attr("checked")){
            return false;
        }

        var rows = $("#deduct-list .rows");
        rows.each(function(){
            var b = $(this).find(".deduct-btn");
            b.removeClass("checked");
        });

        btn.addClass("checked");
    }

    /* 是否需要提成 */
    function isDeduct(e){
        var checkBox = $(e.target);
        var isChecked = checkBox.attr("checked");
        if(!isChecked){
            var rows = $("#deduct-list .rows");
            rows.each(function(){
                var b = $(this).find(".deduct-btn");
                b.removeClass("checked");
            });
        }
    }

    /* 发起合买，进行必要的数据收集 */
    function submit(){
    }
});
