$(function(){
    "use strict";
    var isAllowedSend = true;
    var LASTINGTIME = 10;           // 等待重发间隔时间

    /* 点击注册按钮 */
    $("#regpost").on("click", prepareSubmit);

    /* 点击登录验证 */
    $("#loginpost").on("click", prepareLogin);

    /* 点击修改密码验证 */
    $("#chgpwdpost").on("click", prepareChangePwd);

    /* 点击获取验证码 */
    $("#getcode").on("click", startGetCode);

    /* 重新发送验证码 */
    $("#lasttime").on("click", getCode);

    /* 点击提交银行卡绑定 */
    $("#bankpost").on("click", prepareBankCardSubmit);

    /* 点击提交用户绑定 */
    $("#idcardpost").on("click", prepareIdCardSubmit);

    /* 点击提款 */
    $("#draw_post").on("click", prepareDrawMoney);

    /* 注册之前数据验证 */
    function prepareSubmit(){
    	
        var username = $.trim($("#reg_username").val());
        var escapeName = username.replace(/[^\x00-\xff]/g, "sb");
        var password = $.trim($("#reg_password").val());
        var passwordr = $.trim($("#reg_passwordr").val());
        var code = $("#code").val();
       
        
        if(!isPhoneNumber(escapeName)){
        	showAlert("请输入正确的手机号码");
        	return false;
        }
        if(3 > escapeName.length){
            showAlert("用户名不能少于4位");
            return false;
        }
        else if(17 < escapeName.length){
            showAlert("用户名不能多于16位");
            return false;
        }

        if(5 > password.length){
            showAlert("密码不能少于6位");
            return false;
        }
        else if(16 < password.length){
            showAlert("密码不能长于15位");
            return false;
        }

        if(password != passwordr){
            showAlert("两次输入的密码不一致");
            return false;
        }
        
        if(isEmpty(code)){
            showAlert("验证码不能为空");
            return false;
        }
        
        $("#regform").submit();
    }

    /* 登录之前的验证 */
    function prepareLogin(){
        var username = $.trim($("#un").val());
        var password = $.trim($("#pwd").val());

        if('' === username || undefined === username){
            showAlert("没有用户名不能登录");
            return false;
        }

        if('' === password || undefined === password){
            showAlert("密码不能为空");
            return false;
        }

        $("#loginform").submit();
    }

    /* 修改密码之前的验证 */
    function prepareChangePwd(){
        var oldPwd = $.trim($("#oldpassword").val());
        var newPwd = $.trim($("#newpassword").val());
        var newPwdr = $.trim($("#newpasswordr").val());

        if(!isInRange(oldPwd, 4, 16)){
            showAlert("旧密码长度应该在4-16位");
            return false;
        }
        if(!isInRange(newPwd, 4, 16)){
            showAlert("新密码长度应该在4-16位");
            return false;
        }
        if(newPwd != newPwdr){
            showAlert("两次新密码不一致");
            return false;
        }

        $("#chgpwdform").submit();
    }

    /* 开始获取验证码 */
    function startGetCode(){
        $("#getcode").hide();
        var codeArea = $("#code-input");
        codeArea.children("input").val("");
        codeArea.css("display", "inline-block");
        
        getCode();
    }

    /* 从这里发请验证码请求 */
    function getCode(){
        if(!isAllowedSend){      // 如果还在读秒，则不允计发送验证码
            return ;
        }
        
        var mobileNum = $("#reg_username").val();

        console.log("发送验证码请求了");
        // $.ajax();
        $.ajax({

            type: "POST", //用POST方式传输

            dataType: "text", //数据格式:JSON

            url: 'sendvcode.htm', //目标地址

            data: "mn=" + mobileNum,

            error: function (XMLHttpRequest, textStatus, errorThrown) {alert(textstatus); },

            success: function (msg){

            			if(msg==1){
            				showAlert("该手机号码已注册！");

            			}else if(msg==2){
            				showAlert("请输入正确的手机号码!");
            			}

            		}

        });	       
        
        
        // 请求成功后开始倒计时
        isAllowedSend = false;   // 不允许再发送验证码
        var lastingTime = LASTINGTIME;
        var timeid = window.setInterval(function(){
            --lastingTime;
            $("#lasttime").html("等待重发(" + lastingTime + ")");
            if(0 > lastingTime){
                isAllowedSend = true;
                lastingTime = LASTINGTIME;
                window.clearInterval(timeid);
                $("#lasttime").html("重新发送");
                return ;
            }
        }, 1000);
    }

    /* 用户提交银行卡绑定验证 */
    function prepareBankCardSubmit(){
        var bank = $("#bank").val();
        var province = $("#province").val();
        var city = $("#city").val();
        var bank_card = $("#bank_card").val();
        var realname = $("#realname").val();
        var id_card = $("#id_card").val();
        var bank_pwd = $("#bank_pwd").val();
        var accountName = $("#accountName").val();
        

        if(isEmpty(bank)){
            showAlert("请选择一个银行");
            return false;
        }
        
        /**
        if(isEmpty(province) || isEmpty(city)){
            showAlert("请完整选择银行开户地址");
            return false;
        }
        
        */
        if(isEmpty(bank_card)){
            showAlert("请填写银行卡号");
            return false;
        }
        if(isEmpty(accountName)){
            showAlert("请填写银行开户名");
            return false;
        }        
        if(isEmpty(realname)){
            showAlert("请填写真实姓名");
            return false;
        }
        if(isEmpty(id_card)){
            showAlert("请填写身份证号码");
            return false;
        }
        
        /**
        if(isEmpty(bank_pwd)){
            showAlert("请填写银行密码");
            return false;
        }
        */

        $("#bank_bind_form").submit();
    }

    /* 准备提款验证 */
    function prepareDrawMoney(){
        var realname = $("#realname").val();
        var money = $("#money").val();
        var mobile = $("#mobile").val();

        if(isEmpty(realname)){
            showAlert("银行开户名不能为空");
            return false;
        }
        if(isEmpty(money)){
            showAlert("请填写需要提款金额");
            return false;
        }

        if(!isNumeric(money)){
            showAlert("金额只能是整数");
            return false;
        }

        $("#be_draw_form").submit();
    }

    /* 用户提交身份绑定的验证 */
    function prepareIdCardSubmit(){
    	
        var realname = $("#realname").val();
        var id_number = $("#id_number").val();
        var id_number_r = $("#id_number_r").val();

        if(isEmpty(realname)){
            showAlert("真实姓名不能为空");
            return false;
        }

        if(isEmpty(id_number)){
            showAlert("身份证号不能为空");
            return false;
        }

        if(!isEqual(id_number, id_number_r)){
            showAlert("两次输入身份证号不一致");
            return false;
        }

        $("#id_bind_form").submit();
    }

    /* 密码长度验证 */
    function isInRange(password, start, end){
        password = $.trim(password);

        if(start && password.length < start){
            return false;
        }
        else if(end && password.length > end){
            return false;
        }

        return true;
    }

    /* 检查是否为空 */
    function isEmpty(string){
        string = $.trim(string);

        return ("" === string || null === string ? true : false);
    }

    /* 检查字符串是否相等 */
    function isEqual(str1, str2){
        str1 = $.trim(str1);
        str2 = $.trim(str2);
        
        return (str1 === str2 ? true : false);
    }

    /* 检查是否为纯数字 */
    function isNumeric(num){
        num = $.trim(num);
        var reg = /^\d+$/;
        return reg.test(num);
    }

    /* 验证手机号码 */
    function isPhoneNumber(num){
    	
        var reg = /(^[0-9]{3,4}\-[0-9]{3,8}$)|(^[0-9]{3,8}$)|(^\([0-9]{3,4}\)[0-9]{3,8}$)|(^0{0,1}13[0-9]{9}$)/;
        return reg.test(num);
    }
});

/* 打开我的alert */
function showAlert(msg){
    var tip = $("#dialog-tip");
    tip.html(msg || "");
    openDialog("#dialog");
}
