$(function(){
    "use strict";

    /* 事件注册 */

    // 弹出菜单
    $(".dropbtn").on("click", function(){ toggleMenu($(this)); });

    // 菜单选中
    $(".dropbtn-menu ul li").each(function(){
        $(this).on("click", itemSelected);
    });

    // 倍数复选框
    $(".btn.ratebtn").on("click", function(){ toggleRatebtn($(this)); });

    // 球队复选框
    $(".wcup_table td i.fa").each(function(){
        $(this).on("click", teamSelected);
    });

    // 确定提交
    $("#submit").on("click", function(){
    	
        $.ajax({

            type: "POST",

            url: "caiguanjun.htm",

            data: {jsonar:$("#jsonar").val()},

            dataType: "json",

            success: function(data){
            			if(data){
            				openDialog("#dialog2");
            			}else{
            				openDialog("#dialog3");
            			}
                     }

        });
    	
    });

    // 复合控件
    $("span.addon:first-child").on("click", function(){ calInput($(this), false); });
    $("span.addon:last-child").on("click", function(){ calInput($(this), true); });

    /** 弹出菜单 */
    function toggleMenu(btn){
        var i = btn.find("i.fa");
        i.toggleClass("fa-angle-up");
        i.toggleClass("fa-angle-down");
        $(".dropbtn-menu").toggle();
    }

    /** 菜单选中之后 */
    function itemSelected(e){
        var li = $(e.target);
        var parent = li.parents(".dropbtn-menu");
        var btn = parent.siblings(".dropbtn");
        btn.find("span").html(li.html());
        toggleMenu(parent);

        calAll();
    }

    /** 倍数复选框选取与取消 */
    function toggleRatebtn(btn){
        $(".btn.ratebtn").each(function(){
            $(this).removeClass("checked");
            var l = $(this).find(".checked");
            l.removeClass("none");
            l.addClass("none");
        });
        btn.addClass("checked");
        btn.find(".checked").removeClass("none");

        calAll();
    }

    /** 复合框计算 */
    function calInput(burb, isRaise){
        var input = burb.siblings("input[type='text']");
        var text = parseInt(input.val()) || 0;
        var STEP = 100;
        if(isRaise)
            text += STEP;
        else
            text -= STEP;
        input.val(text);
    }

    /** 球队选择 */
    function teamSelected(e){
        var i = $(e.target);
        i.toggleClass("fa-circle");
        i.toggleClass("fa-check-circle");

        calAll();
    }

    /** 计算金额 */
    function calAll(){
        var data = {};
        data.teams = [];
        /* 取出已选中队伍 */
        $(".wcup_table td i.fa.fa-check-circle").each(function(index){
            var team = {};
            team.name = $(this).data("name");
            team.rate = parseFloat($($(this).parent().siblings("td")[2]).html());
            data.teams.push(team);
        });

        /* 取出已选中倍数 */
        data.rate1 = parseInt($(".btn.ratebtn.checked").data("rate"));

        var rate = $(".dropbtn span").html();
        var reg = /\d/g;

        data.rate2 = parseInt(reg.exec(rate));

        /* 计算最后的数额 */
        var length = data.teams.length;
        var result = data.rate1 * data.rate2 * length * 2;
        var input = $(".btninput input");
        input.val(result);
        data.result = result;

        result = 0;
        for(var i = 0; i < length; ++i){
            result += data.teams[i].rate
        }

        result *= data.rate1 * data.rate2;
        $("#range").html("￥" + result.toFixed(2));

        $("#jsonar").val($.toJSON(data));
    }
});

