v1.4.5 Release Notes - February 19, 2020
========================================

What's New in Hyperledger Fabric v1.4.5
---------------------------------------

The following enhancements are included in this release:

- **FAB-15648: Allow separate TLS config for Raft cluster and client**

  When intra-cluster Raft communication is configured to use separate
  listener, allow TLS to be disabled for the client-facing listener,
  and assume TLS is always enabled for the cluster listener.


Fixes
-----

- **FAB-17261: Add HostConfig to chaincode image builder**

  Prior to the fix, the Docker HostConfig configured in peer was only used
  when creating a chaincode container. The configured Docker HostConfig is
  now used when building a chaincode image and when creating a chaincode container.

- **FAB-17220: Dynamically build TLS config in Raft client handshake**

  This fix ensures that the latest TLS CA certificates are used by Raft ordering
  service nodes when certificates are updated in the channel config.

- **FAB-17289: Fix gossip goroutine memory leak when reading msg**

  A peer gossip memory leak observed in stress tests is fixed.

- **FAB-17327: Static leader should not give up retrieving blocks**

  When a peer is configured as a static org leader for gossip, it will
  not give up on retrieving blocks in the event that the ordering
  service goes down for an extended period of time (i.e. longer than the
  peer.deliveryclient.reconnectTotalTimeThreshold). Prior to the fix,
  the peer had to be restarted before it would retrieve blocks again.

- **FAB-17277: Fix too many TCP connections between peer and CouchDB**

  The peer created a large number of TCP connections to CouchDB because the
  default reusable connection pool size is 2 per host while the max pool size
  is 100 (combining all hosts). Thus only 2 TCP connections could be reused
  by the peer when it accessed CouchDB. When more than two goroutines in the
  peer tried to simultaneously access CouchDB, it resulted in new non-reusable
  connections (i.e., creation of new TCP connection outside the pool).
  The fix sets MaxIdleConns and MaxIdleConnsPerHost to 2000. This creates 2000
  TCP connections in the pool which are reused whenever the peer accesses CouchDB.

- **FAB-17479: Migrated Kafka cluster can be safely expanded later**

  When a new ordering service node was added to a migrated Kafka cluster,
  but was not added to all channels, the ordering service node would crash.
  The fix ensures that new ordering nodes can be added to a subset of channels.

- **FAB-17059: Change collection membership eligibility checks to only compare mspID**

  When a new CA root cert was added to an organization in the channel configuration,
  new peers with an identity from the new CA would not receive private data for
  blocks prior to the channel configuration change. This is because the peer didn't
  realize it was a member of the private data collection, even though it was
  based on the collection's mspid. The fix ensures that the peer evaluates
  private data collection membership based on its mspid. The fix is important
  when rotating CA root or intermediate certs, for example in a side-by-side
  migration scenario that uses new CA certs and new peers.


Changes, Known Issues, and Workarounds
--------------------------------------

- **FAB-12134: Same chaincode source receiving fingerprint mismatch error** -
  Chaincode installed in different ways may result in "chaincode fingerprint
  mismatch data mismatch" error upon instantiation. This may happen when
  installing chaincode by using different SDKs. To workaround the problem,
  package the chaincode prior to installation and instantiation, by using
  the "peer chaincode package" command.


Known Vulnerabilities
---------------------

- **FAB-8664: Peer should detect and react when its org has been removed**
  This is a relatively low severity problem, because it requires a significant
  conspiracy of network admins, but it will be addressed in a future release.


Resolved Vulnerabilities
------------------------
None.


Deprecations
------------
The following functions are deprecated and are targeted for removal in a future release.

- **Support for automatically vendoring the chaincode shim into user chaincodes**

  The fabric-ccenv image which is used to build chaincode, currently includes
  the github.com/hyperledger/fabric/core/chaincode/shim ("shim") package.
  This is convenient, as it provides the ability to package chaincode
  without the need to include the "shim". However, this may cause issues in future
  releases (and/or when trying to use packages which are included by the "shim").
  In order to avoid any issues, users are advised to manually vendor the "shim"
  package with their chaincode prior to using the peer CLI for packaging and/or
  for installing chaincode.
  For more details see FAB-5177.

- **Support for CAR chaincode package format**

  Support for packaging chaincode using the CAR format will be removed in
  a future release.
  For more details see FAB-14720.

- **Support for specifying orderer endpoints at the global level in channel configuration.**

  Utilize the new 'OrdererEndpoints' stanza within the channel configuration of
  an organization instead.
  For more details see FAB-7559.

- **Support for invoking system chaincodes from user chaincodes.**

  System chaincodes, for example QSCC, are intended to be invoked by
  a client rather than by a user chaincode. Invoking from a user chaincode
  may cause deadlocks.
  For more details see FAB-15285.

- **Support for user chaincodes to utilize the chaincode shim's logger via NewLogger()**

  Chaincodes that used the shim's NewLogger() will need to shift to their own preferred
  logging mechanism.
  For more details see FAB-15366.

- **Support for peer's Admin service**

  The peer's Admin service exposes APIs such as GetLogSpec() and SetLogSpec().
  Instead of using these services, utilize the HTTP operations service that was
  introduced in v1.4.0.
  For more details see FAB-15390.

- **Support for Solo ordering service**

  With the introduction of Raft-based ordering service in v1.4.1, it is possible
  to deploy a single-node (non-production) or multi-node
  Raft-based ordering service with no external dependencies.
  For single-node (non-production) ordering services, utilize Raft-based ordering
  service with a single node instead of Solo ordering service.
  For more details see FAB-15754.


Change log
----------
For the full list of changes, refer to the release change log:
https://github.com/hyperledger/fabric/blob/release-1.4/CHANGELOG.md#v145
