v1.4.9 Release Notes - September 30, 2020
=========================================

What's New in Hyperledger Fabric v1.4.9
---------------------------------------
Hyperledger Fabric v1.4.9 provides important improvements and fixes, with a focus on the following areas:
* Management of certificate expirations
* Hardware security module (HSM) efficiency


Fixes
-----

**FAB-18163: orderer certificate expiration - TLSHandshakeTimeShift without separate cluster port**

If the TLS certificates of the ordering service nodes expire and are not replaced in time,
communication between them cannot be established, making it impossible to send
new transactions to the ordering service. To recover from such a scenario, it is possible
to configure a backwards timeshift that ordering service nodes will utilize for TLS
handshakes so that transactions can be processed.
If the Raft cluster service is sharing the orderer’s main gRPC server port,
configure the new orderer.yaml `General.TLS.TLSHandshakeTimeShift` property.
If using a separate cluster listener port,
configure the orderer.yaml `General.Cluster.TLSHandshakeTimeShift` property.

**FAB-18205: orderer certificate expiration - Permit peer CLI to communicate with orderers with expired TLS certificates**

The change allows peer CLI to communicate with ordering service nodes with expired TLS certificates
by setting the `--tlsHandshakeTimeShift` flag to a desired backwards timeshift.
The change applies to the `peer channel fetch` and `peer channel update` commands to allow
fetching configuration blocks and updating the channel configuration for orderers with expired TLS certificates.

**FAB-18171: orderer certificate expiration - Disregard certificate validity period in intra-orderer communication**

This change makes the orderer cluster authentication infrastructure
disregard validity periods when comparing certificates, and only regard public keys.
With this change, an expiring Raft TLS certificate can be replaced
with a new certificate that has the same public key, without requiring channel configuration updates.

**FAB-18188: peer and orderer certificate expiration - Log expiration date upon startup**

The enrollment, TLS server, and TLS client certificate expiration dates are now logged upon peer and orderer startup.

**peer and orderer PKCS#11 - Add object handle cache**

With this change, object handles are cached in the PKCS#11 implementation.
In support of this change, in addition to pooling idle sessions, the
provider tracks active sessions. If some condition occurs that results
in all sessions being closed, cached object handles are no longer valid
so the handle cache is purged.

**FAB-18208: peer - Do not sign gossip message if membership is empty**

This change suppresses the signing of gossip messages if the message will not get
sent regardless due to an empty gossip membership. The change reduces CPU consumption
and eliminates unnecessary calls to an HSM.

**FAB-18250: peer and orderer PKCS#11 - Introduce error checking for evicting invalid PKCS#11 sessions**

FAB-17722 introduced a call to the pkcs11 GetSessionInfo function for retrieving the current state of
the PKCS11 session. The result of this function was used to determine whether a session was still
valid to perform HSM operations or if it should be evicted from the session pool. Performance tests
showed that the call to GetSessionInfo was computationally prohibitively expensive. FAB-18242 reverted
this change and FAB-18250 introduced a new method for determining if the PKCS11 session is invalid.
Now when an HSM operation fails, we check the resultant error against the known session error codes and
evict the session from the pool if the error was the result of an invalid session.

**FAB-17539: peer - Always remember gossip anchor peers in membership**

Gossip removes a peer from its membership cache if no new heartbeats are received from the peer within a timely manner.
If a network partition persists for too long, peers of different organizations never re-establish communication because all membership is purged.
With the fix, anchor peers are no longer removed from the membership cache even if they are offline.
Therefore, after the network partition is healed, peers among different organizations can reestablish communication as long as anchor peers are reachable.

**peer - Verify user chaincodes are called with a channel context**

While system chaincodes can be called without a channel context, user
chaincodes always require a channel context. This fix ensures that
a channel context is available for calls to user chaincodes, and
returns an error if the client did not pass a channel name.


Dependencies
------------
Fabric v1.4.9 has been tested with the following dependencies:
* Go 1.13.12
* Fabric baseimage 0.4.21
* CouchDB v2.3.1


Changes, Known Issues, and Workarounds
--------------------------------------

**FAB-12134: Same chaincode source receiving fingerprint mismatch error** -
Chaincode installed in different ways may result in "chaincode fingerprint
mismatch data mismatch" error upon instantiation. This may happen when
installing chaincode by using different SDKs. To workaround the problem,
package the chaincode prior to installation and instantiation, by using
the "peer chaincode package" command.


Known Vulnerabilities
---------------------

**FAB-8664: Peer should detect and react when its org has been removed**
This is a relatively low severity problem, because it requires a significant
conspiracy of network admins, but it will be addressed in a future release.


Resolved Vulnerabilities
------------------------
None.


Deprecations (existing)
-----------------------
The following functions are deprecated and are targeted for removal in a future release.

**Support for automatically vendoring the chaincode shim into user chaincodes**

The fabric-ccenv image which is used to build chaincode, currently includes
the github.com/hyperledger/fabric/core/chaincode/shim ("shim") package.
This is convenient, as it provides the ability to package chaincode
without the need to include the "shim". However, this may cause issues in future
releases (and/or when trying to use packages which are included by the "shim").
In order to avoid any issues, users are advised to manually vendor the "shim"
package with their chaincode prior to using the peer CLI for packaging and/or
for installing chaincode.
Support removed in v2.0. For more details see FAB-5177.

**Support for CAR chaincode package format**

Support for packaging chaincode using the CAR format will be removed in
a future release.
Support removed in v2.0. For more details see FAB-14720.

**Support for invoking system chaincodes from user chaincodes.**

System chaincodes, for example QSCC, are intended to be invoked by
a client rather than by a user chaincode. Invoking from a user chaincode
may cause deadlocks.
Support removed in v2.0. For more details see FAB-15285.

**Support for user chaincodes to utilize the chaincode shim's logger via NewLogger()**

Chaincodes that used the shim's NewLogger() will need to shift to their own preferred
logging mechanism.
Support removed in v2.0. For more details see FAB-15366.

**Support for peer's Admin service**

The peer's Admin service exposes APIs such as GetLogSpec() and SetLogSpec().
Instead of using these services, utilize the HTTP operations service that was
introduced in v1.4.0.
Support removed in v2.0. For more details see FAB-15390.

**Support for specifying orderer endpoints at the global level in channel configuration.**

Utilize the new 'OrdererEndpoints' stanza within the channel configuration of
an organization instead.
For more details see FAB-7559.

**The 'Solo' consensus type is deprecated.**

With the introduction of Raft-based ordering service in v1.4.1, it is possible
to deploy a single-node (non-production) or multi-node
Raft-based ordering service with no external dependencies.
For single-node (non-production) ordering services, utilize Raft-based ordering
service with a single node instead of Solo ordering service.
For more details see FAB-15754.

**The 'Kafka' consensus type is deprecated**

The 'Raft' consensus type was introduced in v1.4.1 and has become the preferred
production consensus type. There is a documented and tested migration path from
Kafka to Raft, and existing users should migrate to the newer Raft consensus type.
For compatibility with existing deployments, Kafka is still supported,
but may be removed entirely in a future release.
Additionally, the fabric-kafka and fabric-zookeeper docker images are no longer updated, maintained, or published.

**fabric-couchdb docker image no longer updated, maintained, or published**

The fabric-couchdb docker image will no longer be updated, maintained, or published.
Users can utilize the official CouchDB docker image maintained by the Apache CouchDB project instead.


Change log
----------
For the full list of changes, refer to the release change log:
https://github.com/hyperledger/fabric/blob/release-1.4/CHANGELOG.md#v149
