/*
 * Copyright 2019 WeBank
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.webank.wedatasphere.linkis.cs.client.listener;

import com.webank.wedatasphere.linkis.common.listener.Event;

/**
 * created by cooperyang on 2020/2/11
 * Description:
 * Manager的作用是为了方便用户将的
 */
public class ContextClientListenerManager {

    private static ContextClientListenerBus<ContextClientListener, Event> contextClientListenerBus;

    public static ContextClientListenerBus<ContextClientListener, Event> getContextClientListenerBus(){
        if (contextClientListenerBus == null){
            synchronized (ContextClientListenerManager.class){
                if (contextClientListenerBus == null){
                    contextClientListenerBus = new ContextClientListenerBus<ContextClientListener, Event>();
                }
            }
        }
        return contextClientListenerBus;
    }

}
