/*
 * Copyright 2019 WeBank
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * author: enjoyyin
 * date: 2018/9/11
 * time: 20:41
 * Description:
 */
package com.webank.wedatasphere.linkis.common.exception;

public enum ExceptionLevel {
    /**
     * warn 1
     * error 2
     * fatal 3
     */
    WARN(1, "warn"),
    ERROR(2, "error"),
    FATAL(3, "fatal"),
    RETRY(4, "retry");
    private int level;
    private String name;
    private ExceptionLevel(int level, String name){
        this.name = name;
        this.level = level;
    }

    public int getLevel() {
        return level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "ExceptionLevel{" +
                "level=" + level +
                ", name='" + name + '\'' +
                '}';
    }
}
