/*
 * Copyright 2019 WeBank
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.webank.wedatasphere.linkis.gateway.ruler.datasource.entity;

import java.util.Objects;

/**
 * @author wang_zh
 * @date 2020/5/22
 */
public class DatasourceMap {

    public DatasourceMap() {}

    public DatasourceMap(String datasourceName, String instance, String serviceId) {
        this.datasourceName = datasourceName;
        this.instance = instance;
        this.serviceId = serviceId;
    }

    private String datasourceName;

    private String instance;

    private String serviceId;

    public String getDatasourceName() {
        return datasourceName;
    }

    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    public String getInstance() {
        return instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public String getServiceId() {
        return serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DatasourceMap that = (DatasourceMap) o;
        return Objects.equals(datasourceName, that.datasourceName) &&
                Objects.equals(instance, that.instance) &&
                Objects.equals(serviceId, that.serviceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(datasourceName, instance, serviceId);
    }
}
