/*
 * Copyright 2019 WeBank
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.webank.wedatasphere.linkis.resourcemanager.dao;

import com.webank.wedatasphere.linkis.resourcemanager.domain.EmResourceMetaData;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * Created by shanhuang on 9/11/18.
 */
public interface EmResourceMetaDataDao {
    List<EmResourceMetaData> getByEmName(@Param("emApplicationName") String emApplicationName);

    EmResourceMetaData getByEmInstance(@Param("emApplicationName") String emApplicationName, @Param("emInstance") String emInstance);

    List<EmResourceMetaData> getAll();

    void insert(EmResourceMetaData emResourceMetaData);

    void update(EmResourceMetaData emResourceMetaData);

    void deleteById(Integer id);
}
