/*
 * Copyright 2019 WeBank
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.webank.wedatasphere.linkis.storage.script.parser

import com.webank.wedatasphere.linkis.storage.exception.StorageErrorException
import com.webank.wedatasphere.linkis.storage.script.{Parser, Variable, VariableParser}


/**
  * Created by johnnwang on 2018/10/23.
  */
abstract class CommonScriptParser extends Parser {

  @scala.throws[StorageErrorException]
  def parse(line: String): Variable = {
    val variableReg = ("\\s*" + prefix + "\\s*(.+)\\s*" + "=" + "\\s*(.+)\\s*").r
    line match {
      case variableReg(key, value) => Variable(VariableParser.VARIABLE, null, key.trim, value.trim)
      case _ => {
        val split = line.split("=")
        if (split.length != 2) throw new StorageErrorException(65000, "不合法的自定义参数")
        val value = split(1).trim
        val subSplit = split(0).split(" ")
        if (subSplit.filter(_ != "").size != 4) throw new StorageErrorException(65000, "不合法的自定义参数")
        if(!subSplit.filter(_ != "")(0).equals(prefixConf))throw new StorageErrorException(65000, "不合法的自定义参数")
        val sortParent = subSplit.filter(_ != "")(1).trim
        val sort = subSplit.filter(_ != "")(2).trim
        val key = subSplit.filter(_ != "")(3).trim
        Variable(sortParent, sort, key,value)
      }
    }
  }
}

