/*
 * Copyright 2019 WeBank
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.webank.wedatasphere.linkis.entrance.utils;

import com.webank.wedatasphere.linkis.common.ServiceInstance;
import com.webank.wedatasphere.linkis.rpc.BaseRPCSender;
import com.webank.wedatasphere.linkis.rpc.Sender;
import com.webank.wedatasphere.linkis.rpc.sender.SpringMVCRPCSender;

public class RPCUtils {

    public static ServiceInstance getServiceInstance(Sender sender) {
        if(sender instanceof SpringMVCRPCSender) {
            return ((SpringMVCRPCSender) sender).serviceInstance();
        } else if(sender instanceof BaseRPCSender) {
            return ServiceInstance.apply(((BaseRPCSender) sender).getApplicationName(), null);
        } else {
            return null;
        }
    }

}
