<!-- Copyright (c) 2016-2019 Wang Shidong & Contributors -->
<!-- Author: Wang Shidong < wsdjeg at 163.com > -->
<!-- URL: https://spacevim.org -->
<!-- License: GPLv3 -->

# Contributing to SpaceVim

SpaceVim is an volunteer effort; we encourage you to pitch in. The community makes SpaceVim what it is.
We have a few guidelines, which we ask all contributors to follow.

You need only consider reading the sections relevant to what you are going to do:

- [Asking for help](#asking-for-help) if you are about to ask an usage question.
- [Reporting issues](#reporting-issues) if you are about to open a new issue.
- [Contributing code](#contributing-code) if you are about to send a Pull Request (PR).

### Asking for help

If you want to ask an usage question, be sure to look first into some places as it may hold the answers:
- [FAQ](https://spacevim.org/faq/): Some of the most frequently asked questions are answered there.
- [documentation](https://spacevim.org/documentation/): It is the general documentation of SpaceVim.
- [gitter room](https://gitter.im/SpaceVim/SpaceVim): The official channel of SpaceVim.

### Reporting issues

Issues have to be reported on [issues tracker](https://github.com/SpaceVim/SpaceVim/issues), Please:

- Search existing issues (including closed!)
- Update SpaceVim to the latest version to see if your problem persists.
- Use a clear title and follow the issue template.
- Include step by step details on how to reproduce it.

### Contributing code

Code contributions are welcome. Please read the following sections carefully.
In any case, feel free to join us on the [gitter room](https://gitter.im/SpaceVim/SpaceVim) to ask
questions about contributing!

#### License

The license is GPLv3 for all the parts of SpaceVim. this includes:

- The initialization and core files.
- All the layer files.
- The documentation

For files not belonging to SpaceVim, such as local packages and libraries, refer to the header file.
Those files should not have an empty header. We may not accept code without a proper header file.

#### Conventions

SpaceVim is based on conventions, mainly for naming functions, keybindings definition and writing
documentation. Please read the [conventions](https://spacevim.org/conventions/) before your first contribution to get to know them.

#### Pull Request

Submit your contribution against the `master` branch. You should not use your master branch
to modify SpaceVim, this branch is considered to be read-only.

You may want to read our [development guidelines](https://spacevim.org/development/).

