" ___vital___
" NOTE: lines between '" ___vital___' is generated by :Vitalize.
" Do not mofidify the code nor insert new lines before '" ___vital___'
function! s:_SID() abort
  return matchstr(expand('<sfile>'), '<SNR>\zs\d\+\ze__SID$')
endfunction
execute join(['function! vital#_incsearch#Over#Commandline#Modules#IgnoreRegexpBackwardWord#import() abort', printf("return map({'backward_word': '', 'make': ''}, \"vital#_incsearch#function('<SNR>%s_' . v:key)\")", s:_SID()), 'endfunction'], "\n")
delfunction s:_SID
" ___vital___
scriptencoding utf-8
let s:save_cpo = &cpo
set cpo&vim

" Improved backward word detection which ignore regular expression
let s:module = {
\	"name" : "IgnoreRegexpBackwardWord"
\}

function! s:backward_word(str, ...)
	let pat = get(a:, 1, '\k\+\s*\|.')
	let flags = s:non_escaped_backslash .
	\   '\%(' . 'z[se]' .
	\   '\|' . '[iIkKfFpPsSdDxXoOwWhHaAlLuUetrbncCZmMvV]' .
	\   '\|' . '%[dxouUCVlcv]' .
	\   '\|' . "%'[a-zA-Z]" .
	\   '\|' . '%#=\d' .
	\   '\|' . 'z\=\d' .
	\   '\)'
	return matchstr(get(split(a:str, flags . '\s*\zs'), -1, ""),
	\   '\%(' . flags . '\s*\|' . pat . '\)$')
endfunction


let s:non_escaped_backslash = '\m\%(\%(^\|[^\\]\)\%(\\\\\)*\)\@<=\\'

function! s:module.on_enter(cmdline)
	function! a:cmdline.backward_word(...)
		return call("s:backward_word", [self.backward()] + a:000)
	endfunction
endfunction

function! s:make()
	return deepcopy(s:module)
endfunction


let &cpo = s:save_cpo
unlet s:save_cpo
