" ___vital___
" NOTE: lines between '" ___vital___' is generated by :Vitalize.
" Do not mofidify the code nor insert new lines before '" ___vital___'
function! s:_SID() abort
  return matchstr(expand('<sfile>'), '<SNR>\zs\d\+\ze__SID$')
endfunction
execute join(['function! vital#_incsearch#Over#Commandline#Modules#Incsearch#import() abort', printf("return map({'escape_regex': '', 'make': ''}, \"vital#_incsearch#function('<SNR>%s_' . v:key)\")", s:_SID()), 'endfunction'], "\n")
delfunction s:_SID
" ___vital___
scriptencoding utf-8
let s:save_cpo = &cpo
set cpo&vim


function! s:escape_regex(pattern)
	return substitute(a:pattern, '^\^', '\\_^', "")
endfunction



let s:module = {
\	"name" : "Incsearch",
\	"highlights" : {
\		"incsearch" : "IncSearch"
\	},
\	"pattern" : "",
\	"search_flag" : "",
\	"mode" : "",
\}


function! s:module.search_hl_off()
	if exists("self.search_hl_id")
		call matchdelete(self.search_hl_id)
		unlet self.search_hl_id
	endif
endfunction


function! s:module.search_hl_on(pattern)
	call self.search_hl_off()
	let self.search_hl_id = matchadd(self.highlights.incsearch, a:pattern)
endfunction


function! s:module.on_enter(...)
	let self.old_pos = getpos(".")
endfunction


function! s:module.on_leave(...)
	call setpos(".", self.old_pos)
	call self.search_hl_off()
endfunction


function! s:module.on_char(cmdline)
	call self.search_hl_off()
	let line = a:cmdline.getline()
	let result = get(matchlist(line, self.pattern), 1, "")
	if result != ""
		let pos = searchpos(result, self.search_flag)
		if pos == [0, 0]
			return
		endif
		call self.search_hl_on('\%' . pos[0] . 'l' . (&ignorecase ? '\c' : "") . s:escape_regex(result))
		redraw
	endif
endfunction


function! s:make(...)
	let module = deepcopy(s:module)
	let module.mode   = get(a:, 1, "/")
	let module.pattern = get(a:, 2, '^\(.\+\)')
	let module.search_flag = get(a:, 3, 'c')
	return module
endfunction



let &cpo = s:save_cpo
unlet s:save_cpo
