" ___vital___
" NOTE: lines between '" ___vital___' is generated by :Vitalize.
" Do not mofidify the code nor insert new lines before '" ___vital___'
function! s:_SID() abort
  return matchstr(expand('<sfile>'), '<SNR>\zs\d\+\ze__SID$')
endfunction
execute join(['function! vital#_incsearch#Over#Commandline#Modules#InsertRegister#import() abort', printf("return map({'_vital_depends': '', 'to_string': '', 'input': '', 'get_cmdline_cword': '', 'make': '', '_vital_loaded': ''}, \"vital#_incsearch#function('<SNR>%s_' . v:key)\")", s:_SID()), 'endfunction'], "\n")
delfunction s:_SID
" ___vital___
scriptencoding utf-8
let s:save_cpo = &cpo
set cpo&vim


function! s:_vital_loaded(V)
	let s:V = a:V
	let s:String  = s:V.import("Over.String")
endfunction


function! s:_vital_depends()
	return [
\		"Over.String",
\	]
endfunction


function! s:to_string(expr)
	return type(a:expr) == type("") ? a:expr : string(a:expr)
endfunction


function! s:input(cmdline)
	let CR_index = index(a:cmdline.input_key_stack(), "\<CR>")
	if CR_index != -1
		let input = a:cmdline.input_key_stack_string()
		let input = input[ : CR_index-1]
		call a:cmdline.set_input_key_stack(a:cmdline.input_key_stack()[CR_index+1 : ])
		return eval(input)
	endif

	let input_text = ""
	if !empty(a:cmdline.input_key_stack())
		let input_text = a:cmdline.input_key_stack_string()
		call a:cmdline.set_input_key_stack([])
	endif

	call a:cmdline.hl_cursor_on()
	try
		redraw
		let input = input("=", input_text, "expression")
		if !empty(input)
			let input = s:to_string(eval(input))
		endif
	catch
		return ""
	finally
		call a:cmdline.hl_cursor_off()
	endtry
	return input
endfunction


let s:module = {
\	"name" : "InsertRegister"
\}



function! s:module.reset()
	let self.cword = expand("<cword>")
	let self.cWORD = expand("<cWORD>")
	let self.cfile = expand("<cfile>")
endfunction

function! s:module.on_enter(...)
	call self.reset()
" 	let self.prefix_key = ""
endfunction


function! s:get_cmdline_cword(backward, cword)
" 	let backward = matchstr(a:backward, '.\{-}\zs\k\+$')
	let backward = a:backward
	if &incsearch == 0 || a:cword == "" || a:backward == "" || s:String.index(a:cword, backward) != 0
		return a:cword
	endif
	return a:cword[len(backward) : ]
endfunction


function! s:module.on_char_pre(cmdline)
	if a:cmdline.is_input("\<C-r>")
		call a:cmdline.setchar('"')
		let self.prefix_key = a:cmdline.input_key()
		let self.old_line = a:cmdline.getline()
		let self.old_pos  = a:cmdline.getpos()
		return
	elseif exists("self.prefix_key")
\		&& a:cmdline.get_tap_key() == self.prefix_key
		call a:cmdline.setline(self.old_line)
		call a:cmdline.setpos(self.old_pos)
		let char = a:cmdline.input_key()
		if char =~ '^[0-9a-zA-z.%#:/"\-*+]$'
			let register = tr(getreg(char), "\n", "\r")
			call a:cmdline.setchar(register)
		elseif char == "="
			call a:cmdline.setchar(s:input(a:cmdline))
		elseif char == "\<C-w>"
			call a:cmdline.setchar(s:get_cmdline_cword(a:cmdline.backward_word(), self.cword))
		elseif char == "\<C-a>"
			call a:cmdline.setchar(self.cWORD)
		elseif char == "\<C-f>"
			call a:cmdline.setchar(self.cfile)
		elseif char == "\<C-r>"
			call a:cmdline.setchar('"')
		else
			call a:cmdline.setchar("")
		endif
" 		elseif a:cmdline.is_input('=', self.prefix_key)
" 			call a:cmdline.setchar(s:input(a:cmdline))
" 		elseif a:cmdline.is_input("\<C-w>", self.prefix_key)
" 			call a:cmdline.setchar(self.cword)
" 		elseif a:cmdline.is_input("\<C-a>", self.prefix_key)
" 			call a:cmdline.setchar(self.cWORD)
" 		elseif a:cmdline.is_input("\<C-f>", self.prefix_key)
" 			call a:cmdline.setchar(self.cfile)
" 		elseif a:cmdline.is_input("\<C-r>", self.prefix_key)
" 			call a:cmdline.setchar('"')
" 		else
" 			call a:cmdline.setchar("")
" 		endif
	endif
endfunction


function! s:module.on_char(cmdline)
	if a:cmdline.is_input("\<C-r>")
		call a:cmdline.tap_keyinput(self.prefix_key)
		call a:cmdline.disable_keymapping()
		call a:cmdline.setpos(a:cmdline.getpos()-1)
	else
		if exists("self.prefix_key")
			call a:cmdline.untap_keyinput(self.prefix_key)
			call a:cmdline.enable_keymapping()
			unlet! self.prefix_key
		endif
	endif
endfunction



function! s:make()
	return deepcopy(s:module)
endfunction

let &cpo = s:save_cpo
unlet s:save_cpo
