---
title: "VIM 中 ctrl 相关的组合键的使用"
categories: [blog_cn, feature_cn]
description: "枚举 Vim 内置的 Ctrl 组合键功能，以及终端下的一些区别"
image: https://user-images.githubusercontent.com/13142418/80597957-32f81e80-8a5b-11ea-9e46-6c78b4fd5453.png
comments: true
commentsID: "VIM 中 ctrl 相关的组合键的使用"
lang: zh
---

# Vim 中 ctrl 组合键的使用

在终端下使用 ctrl 组合键时经常不能达到预期效果，那么问题出在那里呢？

这是因为在某些终端内，由于设置的原因，按键并不能发出准确的指令给到 Vim，导致了 Vim 无法作出正确的响应。

首先，我们看看这些按键都是什么，使用命令 `showkey -a`，然后从 ctrl + a 一直按到 ctrl + z：

| 按键     | 十进制 | 八进制 | 16进制 |
| -------- | ------ | ------ | ------ |
| 1        | 49     | 0061   | 0x31   |
| 2        | 50     | 0062   | 0x32   |
| 3        | 51     | 0063   | 0x33   |
| 4        | 52     | 0064   | 0x34   |
| 5        | 53     | 0065   | 0x35   |
| 6        | 54     | 0066   | 0x36   |
| 7        | 55     | 0067   | 0x37   |
| 8        | 56     | 0070   | 0x38   |
| 9        | 57     | 0071   | 0x39   |
| 0        | 48     | 0060   | 0x30   |
| a        | 97     | 0141   | 0x61   |
| b        | 98     | 0142   | 0x62   |
| c        | 99     | 0143   | 0x63   |
| d        | 100    | 0144   | 0x64   |
| e        | 101    | 0145   | 0x65   |
| f        | 102    | 0146   | 0x66   |
| g        | 103    | 0147   | 0x67   |
| h        | 104    | 0150   | 0x68   |
| i        | 105    | 0151   | 0x69   |
| j        | 106    | 0152   | 0x6a   |
| k        | 107    | 0153   | 0x6b   |
| l        | 108    | 0154   | 0x6c   |
| m        | 109    | 0155   | 0x6d   |
| n        | 110    | 0156   | 0x6e   |
| o        | 111    | 0157   | 0x6f   |
| p        | 112    | 0160   | 0x70   |
| q        | 113    | 0161   | 0x71   |
| r        | 114    | 0162   | 0x72   |
| s        | 115    | 0163   | 0x73   |
| t        | 116    | 0164   | 0x74   |
| u        | 117    | 0165   | 0x75   |
| v        | 118    | 0166   | 0x76   |
| w        | 119    | 0167   | 0x77   |
| x        | 120    | 0170   | 0x78   |
| y        | 121    | 0171   | 0x79   |
| z        | 122    | 0172   | 0x7a   |
| A        | 65     | 0101   | 0x41   |
| A        | 65     | 0101   | 0x41   |
| B        | 66     | 0102   | 0x42   |
| C        | 67     | 0103   | 0x43   |
| D        | 68     | 0104   | 0x44   |
| E        | 69     | 0105   | 0x45   |
| F        | 70     | 0106   | 0x46   |
| G        | 71     | 0107   | 0x47   |
| H        | 72     | 0110   | 0x48   |
| I        | 73     | 0111   | 0x49   |
| J        | 74     | 0112   | 0x4a   |
| K        | 75     | 0113   | 0x4b   |
| L        | 76     | 0114   | 0x4c   |
| M        | 77     | 0115   | 0x4d   |
| N        | 78     | 0116   | 0x4e   |
| O        | 79     | 0117   | 0x4f   |
| P        | 80     | 0120   | 0x50   |
| Q        | 81     | 0121   | 0x51   |
| R        | 82     | 0122   | 0x52   |
| S        | 83     | 0123   | 0x53   |
| T        | 84     | 0124   | 0x54   |
| U        | 85     | 0125   | 0x55   |
| V        | 86     | 0126   | 0x56   |
| W        | 87     | 0127   | 0x57   |
| X        | 88     | 0130   | 0x58   |
| Y        | 89     | 0131   | 0x59   |
| Z        | 90     | 0132   | 0x5a   |
| ctrl + 1 | 49     | 0061   | 0x31   |
| ctrl + 2 | 0      | 0000   | 0x00   |
| ctrl + 3 | 27     | 0033   | 0x1b   |
| ctrl + 4 | 28     | 0034   | 0x1c   |
| ctrl + 6 | 30     | 0036   | 0x1e   |
| ctrl + 7 | 31     | 0037   | 0x1f   |
| ctrl + 8 | 127    | 0177   | 0x7f   |
| ctrl + 9 | 57     | 0071   | 0x39   |
| ctrl + 0 | 48     | 0060   | 0x30   |
| ctrl + D | 4      | 0004   | 0x04   |
| ctrl + A | 1      | 0001   | 0x01   |
| ctrl + B | 2      | 0002   | 0x02   |
| ctrl + C | 3      | 0003   | 0x03   |
| ctrl + D | 4      | 0004   | 0x04   |
| ctrl + E | 5      | 0005   | 0x05   |
| ctrl + F | 6      | 0006   | 0x06   |
| ctrl + G | 7      | 0007   | 0x07   |
| ctrl + H | 8      | 0010   | 0x08   |
| ctrl + I | 9      | 0011   | 0x09   |
| ctrl + J | 10     | 0012   | 0x0a   |
| ctrl + K | 11     | 0013   | 0x0b   |
| ctrl + L | 12     | 0014   | 0x0c   |
| ctrl + M | 13     | 0015   | 0x0d   |
| ctrl + N | 14     | 0016   | 0x0e   |
| ctrl + O | 15     | 0017   | 0x0f   |
| ctrl + P | 16     | 0020   | 0x10   |
| ctrl + Q | 17     | 0021   | 0x11   |
| ctrl + R | 18     | 0022   | 0x12   |
| ctrl + S | 19     | 0023   | 0x13   |
| ctrl + T | 20     | 0024   | 0x14   |
| ctrl + U | 21     | 0025   | 0x15   |
| ctrl + V | 22     | 0026   | 0x16   |
| ctrl + W | 23     | 0027   | 0x17   |
| ctrl + X | 24     | 0030   | 0x18   |
| ctrl + Y | 25     | 0031   | 0x19   |
| ctrl + Z | 26     | 0032   | 0x1a   |
| Tab      | 9      | 0011   | 0x09   |
| Enter    | 13     | 0015   | 0x0d   |
