﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using Telerik.Windows.Controls;
using System.Windows.Controls;

namespace SimpleCRM
{
    /// <summary>
    /// Interaction logic for App.xaml
    /// </summary>
    public partial class App : Application
    {
        public App()
        {
            InitializeComponent();
            StyleManager.ApplicationTheme = new Office_BlueTheme();
            
            LocalizationManager.Manager = new CustomLocalizationManager();
            
        }
    }

    public class CustomLocalizationManager : LocalizationManager
    {
        public override string GetStringOverride(string key)
        {
            switch (key)
            {
                case "GridViewAlwaysVisibleNewRow":
                    return "点击这里添加新项";
            }
            return base.GetStringOverride(key);
        }
    }

    public class MyDataFormDataField : Telerik.Windows.Controls.DataFormDataField
    {
        private bool _applyingTemplate = false;
        private System.Windows.Controls.ContentControl LabelControl;
        private System.Windows.Controls.Grid DescriptionControl;
        private System.Windows.Controls.Grid Container;
        private System.Windows.Controls.ContentPresenter ContentPresenter;
        public MyDataFormDataField()
        {
            DefaultStyleKey = typeof(Telerik.Windows.Controls.DataFormDataField);
        }

        public override void OnApplyTemplate()
        {
            _applyingTemplate = true;
            base.OnApplyTemplate();
            LabelControl = (System.Windows.Controls.ContentControl)GetTemplateChild("PART_Label");
            DescriptionControl = (Grid)GetTemplateChild("DescriptionIcon");
            Container = (Grid)GetTemplateChild("PART_DataFormDataFieldGrid");
            ContentPresenter = (ContentPresenter)GetTemplateChild("PART_ContentPresenter");
            UpdateVisualState();
            _applyingTemplate = false;
        }

        private static void OnVisualPropertyChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            var df = (MyDataFormDataField)d;
            df.UpdateVisualState();

        }

        private void UpdateVisualState()
        {
            if (!_applyingTemplate && (DescriptionControl == null || Container == null))
                OnApplyTemplate();

            if (DescriptionControl != null && Container != null)
            {
                Container.ColumnDefinitions[0].Width = new GridLength(LabelWidth);
                Container.ColumnDefinitions[1].Width = new GridLength(100, GridUnitType.Star);
                Container.ColumnDefinitions[2].Width = GridLength.Auto;

                //DescriptionControl.Visibility = ShowDescription ? Visibility.Visible : Visibility.Collapsed;
            }
        }

        public static readonly DependencyProperty LabelWidthProperty = DependencyProperty.Register("LabelWidth", typeof(double), typeof(MyDataFormDataField), new PropertyMetadata((double)100, OnVisualPropertyChanged));

        public double LabelWidth
        {
            get { return (double)GetValue(LabelWidthProperty); }
            set { SetValue(LabelWidthProperty, value); }
        }

    }


}


