using System;
using System.Collections.Generic;
using Caliburn.Micro;
using SimpleCRM.ViewModels;
using SimpleCRM.Service;

namespace SimpleCRM
{
    public class AppBootstrapper : BootstrapperBase
    {
        SimpleContainer container;

        public AppBootstrapper()
        {
            Initialize();
        }

        protected override void Configure()
        {
            container = new SimpleContainer();

            container.Singleton<IWindowManager, WindowManager>();
            container.Singleton<IEventAggregator, EventAggregator>();

          

            container.PerRequest<IAppBaseShell, AppMainShellViewModel>();

            container.Singleton<DictionarysService, DictionarysService>();
            container.Singleton<ReportService, ReportService>();
            
            container.RegisterPerRequest(typeof(OrderService), "OrderService", typeof(OrderService));
            container.RegisterPerRequest(typeof(OrderListViewModel), "OrderListViewModel", typeof(OrderListViewModel));
            container.RegisterPerRequest(typeof(OrderFormViewModel), "OrderFormViewModel", typeof(OrderFormViewModel));
            container.RegisterPerRequest(typeof(OrderPrintViewModel), "OrderPrintViewModel", typeof(OrderPrintViewModel));


            container.RegisterPerRequest(typeof(CustomerService), "CustomerService", typeof(CustomerService));
            container.RegisterPerRequest(typeof(CustomerListViewModel), "CustomerListViewModel", typeof(CustomerListViewModel));
            container.RegisterPerRequest(typeof(CustomerFormViewModel), "CustomerFormViewModel", typeof(CustomerFormViewModel));

            container.RegisterPerRequest(typeof(GoodsService), "GoodsService", typeof(GoodsService));

            container.RegisterPerRequest(typeof(SalerService), "SalerService", typeof(SalerService));
            container.RegisterPerRequest(typeof(SalerListViewModel), "SalerListViewModel", typeof(SalerListViewModel));
            container.RegisterPerRequest(typeof(SalerFormViewModel), "SalerFormViewModel", typeof(SalerFormViewModel));
            
        }

        protected override object GetInstance(Type service, string key)
        {
            return container.GetInstance(service, key);
        }

        protected override IEnumerable<object> GetAllInstances(Type service)
        {
            return container.GetAllInstances(service);
        }

        protected override void BuildUp(object instance)
        {
            container.BuildUp(instance);
        }

        protected override void OnStartup(object sender, System.Windows.StartupEventArgs e)
        {
            DisplayRootViewFor<IAppBaseShell>();
            ((System.Windows.Application)(sender)).Windows[0].WindowState = System.Windows.WindowState.Maximized;
        }
    }

    public interface IAppBaseShell
    {

    }

}