﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Caliburn.Micro;
using Dapper;
using SimpleCRM.Units;
using SimpleCRM.ViewDAO;
using System.Collections.ObjectModel;
using System.Data;

namespace SimpleCRM.Service
{
    public class GoodsService
    {
        public ObservableCollection<Goods> GetGoods(string conditon)
        {
            string strSql = string.Format("SELECT * FROM T_GOODS WHERE 1=1 {0} ORDER BY ID ASC", string.IsNullOrEmpty((conditon ?? string.Empty)) ? "" : " AND " + conditon);
            var items = new ObservableCollection<Goods>();
            using (IDbConnection cnn = DbHelper.GetConnection())
            {
                items = new ObservableCollection<Goods>(cnn.Query<Goods>(strSql, new DynamicParameters()));
            }
            return items;
        }


        public void AddGoods(Goods item, Order order)
        {
            var oMaps = new Dictionary<string, object>();
            oMaps.Add("OrderID", order.ID);
            oMaps.Add("NAME", item.Name);
            oMaps.Add("Unit", item.Unit);
            oMaps.Add("ACount", item.Acount);
            oMaps.Add("Gross", item.Gross);
            oMaps.Add("Tare", item.Tare);
            oMaps.Add("Suttle", item.Suttle);
            oMaps.Add("Deduction", item.Deduction);
            oMaps.Add("TaxPrice", item.TaxPrice);
            oMaps.Add("Remark", item.Remark);

            string fields = string.Join(",", oMaps.Keys);
            string valueDefineds = string.Join(",", oMaps.Keys.Select(key => string.Format("@{0}", key)));
            string strSql = string.Format("INSERT INTO T_Goods({0}) VALUES({1})", fields, valueDefineds);
            var dynamicParams = new DynamicParameters();
            oMaps.Apply(param => dynamicParams.Add(param.Key, param.Value));

            using (IDbConnection cnn = DbHelper.GetConnection())
            {
                cnn.Execute(strSql, dynamicParams);
            }
        }

        public void UpdateGoods(Goods item)
        {
            var oMaps = new Dictionary<string, object>();

            oMaps.Add("NAME", item.Name);
            oMaps.Add("Unit", item.Unit);
            oMaps.Add("ACount", item.Acount);
            oMaps.Add("Gross", item.Gross);
            oMaps.Add("Tare", item.Tare);
            oMaps.Add("Suttle", item.Suttle);
            oMaps.Add("Deduction", item.Deduction);
            oMaps.Add("TaxPrice", item.TaxPrice);
            oMaps.Add("Remark", item.Remark);

            string fields = string.Join(",", oMaps.Keys.Select(f => string.Format(@"{0}=@{0}", f)));
            string strSql = string.Format("UPDATE T_Goods SET {0} WHERE ID=@ID", fields);
            oMaps.Add("ID", item.ID);
            var dynamicParams = new DynamicParameters();
            oMaps.Apply(param => dynamicParams.Add(param.Key, param.Value));
            using (IDbConnection cnn = DbHelper.GetConnection())
            {
                cnn.Execute(strSql, dynamicParams);
            }
        }
    }
}
