﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Caliburn.Micro;
using Dapper;
using SimpleCRM.Units;
using SimpleCRM.ViewDAO;
using System.Collections.ObjectModel;
using System.Data;

namespace SimpleCRM.Service
{
    public class OrderService
    {
        public ObservableCollection<Order> GetOrders(string conditon)
        {
            var items = new ObservableCollection<Order>();
            string strSql = "SELECT * FROM T_ORDER ORDER BY ID DESC";
            strSql = "SELECT A.*,B.NAME AS CUSTOMERNAME,C.NAME AS SALERNAME,D.NAME AS SaleAreaName FROM T_ORDER A LEFT JOIN T_CUSTOMER B ON A.CUSTOMER=B.ID LEFT JOIN T_SALER C ON A.SALER=C.ID LEFT JOIN T_PROVINCE D ON A.SaleArea=D.ID WHERE 1=1";
            if (!string.IsNullOrEmpty(conditon))
            {
                strSql = strSql + conditon;
            }
            strSql = strSql + " ORDER BY A.ID DESC";

            using (IDbConnection cnn = DbHelper.GetConnection())
            {
                items = new ObservableCollection<Order>(cnn.Query<Order>(strSql, new DynamicParameters()));
            }
            return items;
        }
        /// <summary>
        /// 增加订单，返回订单的主键。
        /// </summary>
        /// <param name="item"></param>
        /// <returns></returns>
        public int AddOrder(Order item)
        {
            int id = 0;
            var oMaps = new Dictionary<string, object>();

            oMaps.Add("ID", item.ID);
            oMaps.Add("CODE", item.Code);
            oMaps.Add("DATE", DateTimeConvertHelper.GetFormatDate(item.CreateDate));
            oMaps.Add("CUSTOMER", item.Customer);
            oMaps.Add("SALER", item.Saler);
            oMaps.Add("YEAR", item.CreateDate.Year);
            oMaps.Add("MONTH", item.CreateDate.Month);
            oMaps.Add("DAY", item.CreateDate.Day);
            oMaps.Add("SALESDEPARTMENT", item.SalesDepartment);
            oMaps.Add("SALEAREA", item.SaleArea);

            string fields = string.Join(",", oMaps.Keys);
            string valueDefineds = string.Join(",", oMaps.Keys.Select(key => string.Format("@{0}", key)));
            string strSql = string.Format("INSERT INTO T_ORDER({0}) VALUES({1})", fields, valueDefineds);
            var dynamicParams = new DynamicParameters();
            oMaps.Apply(param => dynamicParams.Add(param.Key, param.Value));

            string strSelectOrderID = "select max(ID) from T_ORDER";
            using (IDbConnection cnn = DbHelper.GetConnection())
            {
                cnn.Execute(strSql, dynamicParams);
                id = cnn.ExecuteScalar<int>(strSelectOrderID, null);
            }
            return id;
        }

        public void UpdateOrder(Order item)
        {
            var oMaps = new Dictionary<string, object>();

            oMaps.Add("CODE", item.Code);
            oMaps.Add("DATE", DateTimeConvertHelper.GetFormatDate(item.CreateDate));
            oMaps.Add("CUSTOMER", item.Customer);
            oMaps.Add("SALER", item.Saler);
            oMaps.Add("YEAR", item.CreateDate.Year);
            oMaps.Add("MONTH", item.CreateDate.Month);
            oMaps.Add("DAY", item.CreateDate.Day);
            oMaps.Add("SALESDEPARTMENT", item.SalesDepartment);
            oMaps.Add("SALEAREA", item.SaleArea);

            string fields = string.Join(",", oMaps.Keys.Select(f => string.Format(@"{0}=@{0}", f)));
            string strSql = string.Format("UPDATE T_ORDER SET {0} WHERE ID=@ID", fields);
            oMaps.Add("ID", item.ID);
            var dynamicParams = new DynamicParameters();
            oMaps.Apply(param => dynamicParams.Add(param.Key, param.Value));
            using (IDbConnection cnn = DbHelper.GetConnection())
            {
                cnn.Execute(strSql, dynamicParams);
            }
        }
    }
}
