﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Caliburn.Micro;
using Dapper;
using SimpleCRM.Units;
using SimpleCRM.ViewDAO;
using System.Collections.ObjectModel;
using System.Data;

namespace SimpleCRM.Service
{
    public class SalerService
    { 
        public ObservableCollection<Saler> GetSalers(string conditon)
        {
            var items = new ObservableCollection<Saler>();

            string strSql = "SELECT * FROM T_SALER ORDER BY ID DESC";           
            using (IDbConnection cnn = DbHelper.GetConnection())
            {
                items = new ObservableCollection<Saler>(cnn.Query<Saler>(strSql, new DynamicParameters()));
            }
            return items;
        }
        /// <summary>
        /// 增加订单，返回订单的主键。
        /// </summary>
        /// <param name="item"></param>
        /// <returns></returns>
        public int AddSaler(Saler item)
        {
            int id = 0;
            var oMaps = new Dictionary<string, object>();          
            oMaps.Add("Name", item.Name);
            oMaps.Add("Address", item.Address);
            oMaps.Add("Tel", item.Tel);
            oMaps.Add("CreateTime", item.CreateTime);
            oMaps.Add("Remark", item.Remark);
            string fields = string.Join(",", oMaps.Keys);
            string valueDefineds = string.Join(",", oMaps.Keys.Select(key => string.Format("@{0}", key)));
            string strSql = string.Format("INSERT INTO T_Saler({0}) VALUES({1})", fields, valueDefineds);
            var dynamicParams = new DynamicParameters();
            oMaps.Apply(param => dynamicParams.Add(param.Key, param.Value));            
            using (IDbConnection cnn = DbHelper.GetConnection())
            {
                cnn.Execute(strSql, dynamicParams);                
            }
            return id;
        }

        public void UpdateSaler(Saler item)
        {
            var oMaps = new Dictionary<string, object>();
            oMaps.Add("Name", item.Name);
            oMaps.Add("Address", item.Address);
            oMaps.Add("Tel", item.Tel);
            oMaps.Add("CreateTime", item.CreateTime);
            oMaps.Add("Remark", item.Remark);
            string fields = string.Join(",", oMaps.Keys.Select(f => string.Format(@"{0}=@{0}", f)));
            string strSql = string.Format("UPDATE T_Saler SET {0} WHERE ID=@ID", fields);
            oMaps.Add("ID", item.ID);
            var dynamicParams = new DynamicParameters();
            oMaps.Apply(param => dynamicParams.Add(param.Key, param.Value));
            using (IDbConnection cnn = DbHelper.GetConnection())
            {
                cnn.Execute(strSql, dynamicParams);
            }
        }

        public void UpdateSalerLayoffState(Saler item)
        {
            var oMaps = new Dictionary<string, object>();
            oMaps.Add("IsLayoff", item.IsLayoff);          
            string fields = string.Join(",", oMaps.Keys.Select(f => string.Format(@"{0}=@{0}", f)));
            string strSql = string.Format("UPDATE T_Saler SET {0} WHERE ID=@ID", fields);
            oMaps.Add("ID", item.ID);
            var dynamicParams = new DynamicParameters();
            oMaps.Apply(param => dynamicParams.Add(param.Key, param.Value));
            using (IDbConnection cnn = DbHelper.GetConnection())
            {
                cnn.Execute(strSql, dynamicParams);
            }
        }
    }
}
