﻿using Dapper;
using SimpleCRM.Units;
using System;
using System.Collections.Generic;
using System;
using System.ComponentModel;
namespace SimpleCRM.ViewDAO
{

    //实现IEditableObject接口才会使delete按钮处于启用状态
    public class Order : IEditableObject, IIDSign
    {
        public int ID { get; set; }
        public string Code { get; set; }
        public string Date { get; set; }
        public string Warehouse { get; set; }
        public int Customer { get; set; }
        public string CustomerType { get; set; }
        public int Saler { get; set; }
        public int SalesDepartment { get; set; }
        public int SaleArea { get; set; }
        public string Remark { get; set; }

        /// <summary>
        /// 这个属性更多的是为了试图上显示用，其意义和Date相同
        /// </summary>
        public DateTime CreateDate { get; set; }

        public string CustomerName { get; set; }
        public string SalerName { get; set; }
        public string SaleAreaName { get; set; }

        public void BeginEdit()
        {
        }
        public void EndEdit()
        {
        }
        public void CancelEdit()
        {
        }
    }

    public enum FormViewModel
    {
        Insert,
        Edit,
        ReadOnly
    }

    public class OrderEventArgs
    {
        public FormViewModel FormViewModel { get; set; }
        public Order Order { get; set; }
    }

    public class OrderAddedEventArgs
    {
        public string Condition { get; set; }
    }
}
