﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using Telerik.Windows.Controls;
using Telerik.Windows.Controls.Data.DataForm;

namespace SimpleCRM.ViewDAO
{
    public class CustomCommandProvider : DataFormCommandProvider
    {
        Caliburn.Micro.Screen Screen;
        public CustomCommandProvider() : base(null)
        {

        }
        public CustomCommandProvider(RadDataForm dataForm, Caliburn.Micro.Screen _screen)
                : base(dataForm)
        {
            this.DataForm = dataForm;
            this.Screen = _screen;
        }

        protected override void MoveCurrentToNext()
        {
            if (this.DataForm != null)
            {
                this.DataForm.MoveCurrentToNext();
                this.DataForm.BeginEdit();
                MessageBox.Show("Command provider is working!");
            }
        }

        protected override void CommitEdit()
        {
            if (this.DataForm != null && this.DataForm.ValidateItem())
            {
                this.DataForm.CommitEdit();
            }
        }

        protected override void CancelEdit()
        {
            this.Screen.TryClose();
        }
    }
}
