﻿using Caliburn.Micro;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Dapper;
using System.Data.OleDb;
using System.Data.SQLite;
using System.Data;
using System.Configuration;
using SimpleCRM.ViewDAO;
using SimpleCRM.Units;
using Telerik.Windows.Controls;
using System.Collections;
using System.Windows.Data;
using System.Windows;
using Telerik.Windows.Controls.GridView;
using System.Globalization;
using SimpleCRM.Service;

namespace SimpleCRM.ViewModels
{
    public class CustomerFormViewModel : Caliburn.Micro.Screen, IHandle<CustomerEventArgs>
    {
        private readonly IEventAggregator eventAggregator;
        private readonly CustomerService customerService;

        public CustomerFormViewModel(IEventAggregator _eventAggregator, CustomerService _CustomerService)
        {
            eventAggregator = _eventAggregator;
            eventAggregator.Subscribe(this);
            customerService = _CustomerService;
        }

        private ObservableCollection<Customer> items = new ObservableCollection<Customer>();
        public ObservableCollection<Customer> Items { get { return items; } set { items = value; } }

        public RadDataForm MyRadDataForm { get; set; }
        public FormViewModel FormViewModel { get; set; }
        protected override void OnViewLoaded(object view)
        {
            this.MyRadDataForm = (Telerik.Windows.Controls.RadDataForm)((System.Windows.Controls.ContentControl)view).Content;
            this.MyRadDataForm.EditEnded += MyRadDataForm_EditEnded;
            MyRadDataForm.CommandProvider = new CustomCommandProvider(MyRadDataForm, this);
        }

        private void MyRadDataForm_EditEnded(object sender, Telerik.Windows.Controls.Data.DataForm.EditEndedEventArgs e)
        {
            if (this.FormViewModel == FormViewModel.Insert)
            {
                AddItem();
            }

            if (this.FormViewModel == FormViewModel.Edit)
            {
                UpdateItem();
            }
            eventAggregator.PublishOnUIThread(new CustomerAddedEventArgs());
            this.TryClose();
        }

        private void AddItem()
        {
            customerService.AddCustomer(this.GetCurrentItem());
            CacheHelper.RemoveCacheItem(DictionarysService.CUSTOMER_CACHE_KEY);
        }


        private void UpdateItem()
        {
            customerService.UpdateCustomer(this.GetCurrentItem());
            CacheHelper.RemoveCacheItem(DictionarysService.CUSTOMER_CACHE_KEY);
        }


        private Customer GetCurrentItem()
        {
            return this.Items.FirstOrDefault();
        }

        public void Handle(CustomerEventArgs message)
        {
            eventAggregator.Unsubscribe(this);
            this.FormViewModel = message.FormViewModel;
            var customer = message.Customer;
            //customer.ID = 1;
            //customer.Name = "TEst";
            customer.CreateTime = DateTime.Now;
            if (message.FormViewModel == FormViewModel.Insert)
            {

            }
            if (message.FormViewModel == FormViewModel.Edit)
            {
                IFormatProvider ifp = new CultureInfo("zh-CN", true);
                //order.CreateDate = DateTime.ParseExact(order.Date, "yyyyMMdd", ifp);
            }
            this.Items.Clear();
            this.Items.Add(customer);
        }
    }
}
