﻿using Caliburn.Micro;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Dapper;
using System.Data.OleDb;
using System.Data.SQLite;
using System.Data;
using System.Configuration;
using SimpleCRM.ViewDAO;
using SimpleCRM.Units;
using System.Windows.Data;
using System.Globalization;
using System.Dynamic;
using System.Windows;
using SimpleCRM.Service;

namespace SimpleCRM.ViewModels
{
    public class CustomerListViewModel : Caliburn.Micro.PropertyChangedBase, IHandle<CustomerAddedEventArgs>
    {
        private readonly IWindowManager windowManager;
        private readonly IEventAggregator eventAggregator;
        private readonly CustomerService customerService;
        public CustomerListViewModel(IWindowManager _windowManager, IEventAggregator _eventAggregator, CustomerService _CustomerService)
        {
            windowManager = _windowManager;
            eventAggregator = _eventAggregator;
            eventAggregator.Subscribe(this);
            customerService = _CustomerService;
            BindListDatas();
        }

        private ObservableCollection<Customer> items = new ObservableCollection<Customer>();
        public ObservableCollection<Customer> Items { get { return items; } set { items = value; NotifyOfPropertyChange(() => Items); } }


        private void BindListDatas()
        {
            Items = customerService.GetCustomers(string.Empty);
        }

        public void Handle(CustomerAddedEventArgs message)
        {
            BindListDatas();
        }

        public void GridView_MouseDoubleClick(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            var item = ((Telerik.Windows.Controls.DataControl)sender).SelectedItem as Customer;
            object addView = IoC.Get<CustomerFormViewModel>();
            eventAggregator.PublishOnUIThread(new CustomerEventArgs() { Customer = item, FormViewModel = FormViewModel.Edit });
            dynamic settings = new ExpandoObject();
            settings.WindowStartupLocation = WindowStartupLocation.CenterScreen;
            settings.AllowsTransparency = true;
            settings.WindowStyle = WindowState.Normal;
            windowManager.ShowDialog(addView, null, settings);
        }

    }

}
