﻿using Caliburn.Micro;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Dapper;
using System.Data.OleDb;
using System.Data.SQLite;
using System.Data;
using System.Configuration;
using SimpleCRM.ViewDAO;
using SimpleCRM.Units;
using System.Windows.Data;
using System.Globalization;
using System.Dynamic;
using System.Windows;
using SimpleCRM.Service;
using Telerik.Windows.Controls;

namespace SimpleCRM.ViewModels
{
    public class OrderListViewModel : Caliburn.Micro.PropertyChangedBase, IHandle<OrderAddedEventArgs>
    {
        private readonly IWindowManager windowManager;
        private readonly IEventAggregator eventAggregator;
        private readonly OrderService orderService;
        public OrderListViewModel(IWindowManager _windowManager, IEventAggregator _eventAggregator, OrderService _OrderService)
        {
            windowManager = _windowManager;
            eventAggregator = _eventAggregator;
            eventAggregator.Subscribe(this);
            orderService = _OrderService;
            //BindListDatas(string.Empty);
        }

        private ObservableCollection<Order> items = new ObservableCollection<Order>();
        public ObservableCollection<Order> Items { get { return items; } set { items = value; NotifyOfPropertyChange(() => Items); } }


        private void BindListDatas(string condition)
        {
            Items = orderService.GetOrders(condition);
        }

        public void Handle(OrderAddedEventArgs message)
        {
            BindListDatas(message.Condition);
        }

        public void GridView_MouseDoubleClick(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            var orderItem = ((Telerik.Windows.Controls.DataControl)sender).SelectedItem as Order;
            object addView = IoC.Get<OrderFormViewModel>();
            eventAggregator.PublishOnUIThread(new OrderEventArgs() { Order = orderItem, FormViewModel = FormViewModel.Edit });
            dynamic settings = new ExpandoObject();
            settings.WindowStartupLocation = WindowStartupLocation.CenterScreen;
            settings.AllowsTransparency = true;
            settings.WindowStyle = WindowState.Normal;
            windowManager.ShowDialog(addView, null, settings);
        }

        public void GridView_SelectionChanged(object sender, SelectionChangeEventArgs e)
        {
            var orderItem = ((Telerik.Windows.Controls.DataControl)sender).SelectedItem as Order;
            eventAggregator.PublishOnUIThread(new OrderEventArgs() { Order = orderItem, FormViewModel = FormViewModel.Edit });
        }

    }

}
