﻿using Caliburn.Micro;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Dapper;
using System.Data.OleDb;
using System.Data.SQLite;
using System.Data;
using System.Configuration;
using SimpleCRM.ViewDAO;
using SimpleCRM.Units;
using System.Windows.Data;
using System.Globalization;
using System.Dynamic;
using System.Windows;
using SimpleCRM.Service;

namespace SimpleCRM.ViewModels
{
    public class SalerListViewModel : Caliburn.Micro.PropertyChangedBase, IHandle<SalerAddedEventArgs>
    {
        private readonly IWindowManager windowManager;
        private readonly IEventAggregator eventAggregator;
        private readonly SalerService salerServiceService;
        public SalerListViewModel(IWindowManager _windowManager, IEventAggregator _eventAggregator, SalerService _SalerService)
        {
            windowManager = _windowManager;
            eventAggregator = _eventAggregator;
            eventAggregator.Subscribe(this);
            salerServiceService = _SalerService;
            BindListDatas();
        }

        private ObservableCollection<Saler> items = new ObservableCollection<Saler>();
        public ObservableCollection<Saler> Items { get { return items; } set { items = value; NotifyOfPropertyChange(() => Items); } }


        private void BindListDatas()
        {
            Items = salerServiceService.GetSalers(string.Empty);
        }

        public void Handle(SalerAddedEventArgs message)
        {
            BindListDatas();
        }

        public void GridView_MouseDoubleClick(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            var item = ((Telerik.Windows.Controls.DataControl)sender).SelectedItem as Saler;
            object addView = IoC.Get<SalerFormViewModel>();
            eventAggregator.PublishOnUIThread(new SalerEventArgs() { Saler = item, FormViewModel = FormViewModel.Edit });
            dynamic settings = new ExpandoObject();
            settings.WindowStartupLocation = WindowStartupLocation.CenterScreen;
            settings.AllowsTransparency = true;
            settings.WindowStyle = WindowState.Normal;
            windowManager.ShowDialog(addView, null, settings);
        }

        public void Layoff_Click(object sender)
        {
            var item = ((Telerik.Windows.Controls.RadButton)sender);
            var cell = (Telerik.Windows.Controls.GridView.GridViewCell)item.Parent;
            Saler saler = cell.DataContext as Saler;
            saler.IsLayoff = saler.IsLayoff == 0 ? 1 : 0;
            salerServiceService.UpdateSalerLayoffState(saler);
            BindListDatas();
            CacheHelper.RemoveCacheItem(DictionarysService.SALER_CACHE_KEY);
        }

    }

}
