/*
 * Decompiled with CFR 0.152.
 */
package com.sina.sae.fetchurl;

import com.sina.sae.fetchurl.BinaryData;
import com.sina.sae.fetchurl.FetchurlUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class ApiBusFetchurl {
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String DELETE = "DELETE";
    private static final String PUT = "PUT";
    private static final String HEAD = "HEAD";
    private static final String OPTIONS = "OPTIONS";
    private static final String TRACE = "TRACE";
    private static final int MAX_REDIRECT_NUM = 5;
    private static final int MAX_SEND_DATA = 0xA00000;
    private static Logger logger = Logger.getLogger((String)ApiBusFetchurl.class.getName());
    private final String accessKey;
    private final String secretKey;
    private String method = "GET";
    private final HttpClient httpclient = FetchurlUtil.wrapClient((HttpClient)new DefaultHttpClient());
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Map<String, ArrayList<String>> reduplicateHeaders = new HashMap<String, ArrayList<String>>();
    private HttpRequestBase http;
    private final Set<String> forbidHead = new HashSet<String>();
    private Map<String, String> addHttpHeaders = new HashMap<String, String>();
    private Map<String, ArrayList<String>> reduplicateAddHttpHeaders = new HashMap<String, ArrayList<String>>();
    private Map<String, String> postMap;
    private boolean isPost = false;
    private int saeStatusCode = 0;
    private int httpStatusCode = 200;
    private String statusMsg = "";
    private boolean isAllowRedirect = true;
    private List<BinaryData> binaryList = new ArrayList<BinaryData>();
    private String body = "";
    private String characterEncode = "UTF-8";
    private boolean isTrunacated = false;

    public ApiBusFetchurl() {
        Random rand = new Random();
        this.accessKey = Integer.toHexString(rand.nextInt());
        this.secretKey = Long.toHexString(rand.nextLong());
        this.initForbidHeaders();
    }

    public ApiBusFetchurl(String accessKey, String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.initForbidHeaders();
    }

    private void initForbidHeaders() {
        this.forbidHead.add("content-length");
        this.forbidHead.add("host");
        this.forbidHead.add("vary");
        this.forbidHead.add("via");
        this.forbidHead.add("x-forwarded-for");
        this.forbidHead.add("fetchUrl");
        this.forbidHead.add("accessKey");
        this.forbidHead.add("timeStamp");
        this.forbidHead.add("signature");
        this.forbidHead.add("allowTruncated");
        this.forbidHead.add("connectTimeout");
        this.forbidHead.add("sendTimeout");
        this.forbidHead.add("readTimeout");
    }

    private HttpRequestBase choiceHttpMethod(String method, String url) {
        String httpMethod = method.toUpperCase();
        if (GET.equals(httpMethod)) {
            return new HttpGet(url);
        }
        if (POST.equals(httpMethod)) {
            return new HttpPost(url);
        }
        if (DELETE.equals(httpMethod)) {
            return new HttpDelete(url);
        }
        if (PUT.equals(httpMethod)) {
            return new HttpPut(url);
        }
        if (HEAD.equals(httpMethod)) {
            return new HttpHead(url);
        }
        if (OPTIONS.equals(httpMethod)) {
            return new HttpOptions(url);
        }
        if (TRACE.equals(httpMethod)) {
            return new HttpTrace(url);
        }
        return new HttpGet(url);
    }

    private void genPostRequest(HttpRequestBase httpBase) {
        if (httpBase instanceof HttpPost) {
            try {
                HttpPost post = (HttpPost)httpBase;
                if (this.postMap != null && this.binaryList.size() == 0) {
                    ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                    Set<Map.Entry<String, String>> entry = this.postMap.entrySet();
                    for (Map.Entry<String, String> entryValue : entry) {
                        String name = entryValue.getKey();
                        String value = entryValue.getValue();
                        nvps.add(new BasicNameValuePair(name, value));
                    }
                    if (null == this.characterEncode || "".equals(this.characterEncode)) {
                        this.characterEncode = "UTF-8";
                    }
                    post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, this.characterEncode));
                }
                if (this.binaryList.size() > 0) {
                    MultipartEntity entity = new MultipartEntity();
                    Iterator<BinaryData> binaryIter = this.binaryList.iterator();
                    int size = 0;
                    while (binaryIter.hasNext()) {
                        BinaryData bd = binaryIter.next();
                        ByteArrayBody bab = null;
                        if (this.isTrunacated) {
                            if (size + bd.getPostData().length > 0xA00000) {
                                bab = new ByteArrayBody(bd.getPostData(), bd.getFileName());
                                logger.warn((Object)"send data is over 10M");
                                break;
                            }
                            size += bd.getPostData().length;
                            bab = new ByteArrayBody(bd.getPostData(), bd.getFileName());
                            continue;
                        }
                        bab = new ByteArrayBody(bd.getPostData(), bd.getFileName());
                        entity.addPart(bd.getInputParameterName(), (ContentBody)bab);
                    }
                    if (this.postMap != null) {
                        Set<Map.Entry<String, String>> entry = this.postMap.entrySet();
                        for (Map.Entry<String, String> entryValue : entry) {
                            String name = entryValue.getKey();
                            String value = entryValue.getValue();
                            entity.addPart(name, (ContentBody)new StringBody(value));
                        }
                    }
                    post.setEntity((HttpEntity)entity);
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"gen post request header failure.", (Throwable)e);
            }
        } else {
            logger.error((Object)"current http method not post!");
        }
    }

    private void parseResponseStatus(HttpResponse response) {
        StatusLine line = response.getStatusLine();
        int statusCode = line.getStatusCode();
        String reasonPhrase = line.getReasonPhrase();
        if (200 == statusCode) {
            this.saeStatusCode = 0;
        } else {
            this.saeStatusCode = statusCode;
            this.httpStatusCode = statusCode;
        }
        this.statusMsg = "OK".equals(reasonPhrase) ? "" : reasonPhrase;
    }

    private void debugRequestHeader(HttpRequestBase http) {
        logger.debug((Object)("request url = " + http.getRequestLine().getUri()));
        logger.debug((Object)("request method = " + http.getRequestLine().getMethod()));
        logger.debug((Object)("request http version = " + http.getRequestLine().getProtocolVersion()));
        Header[] headers = http.getAllHeaders();
        logger.debug((Object)"request headers:");
        for (Header h : headers) {
            logger.debug((Object)(h.getName() + " : " + h.getValue()));
        }
    }

    private void debugPostData(HttpEntity entity) {
        try {
            logger.debug((Object)EntityUtils.toString((HttpEntity)entity));
        }
        catch (ParseException e) {
            logger.error((Object)"debug failure", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"debug failure", (Throwable)e);
        }
    }

    private HttpEntity reFetch(String redirectUrl) {
        try {
            boolean isRedirect = true;
            HttpResponse response = null;
            block3: for (int i = 0; i < 5 && isRedirect; ++i) {
                HttpGet get = new HttpGet(redirectUrl);
                this.genHttpHeader((HttpRequestBase)get, redirectUrl);
                if (logger.isDebugEnabled()) {
                    this.debugRequestHeader((HttpRequestBase)get);
                }
                response = new DefaultHttpClient().execute((HttpUriRequest)get);
                Header[] responseHeaders = response.getAllHeaders();
                if (logger.isDebugEnabled()) {
                    for (Header h : responseHeaders) {
                        logger.debug((Object)(h.getName() + ":" + h.getValue()));
                    }
                }
                for (Header h : responseHeaders) {
                    if ("Location".equals(h.getName())) {
                        redirectUrl = h.getValue();
                        continue;
                    }
                    if ("location".equals(h.getName())) {
                        redirectUrl = h.getValue();
                        continue;
                    }
                    isRedirect = false;
                    continue block3;
                }
            }
            if (response != null) {
                Header[] responseHeaders = response.getAllHeaders();
                this.headers.clear();
                for (Header h : responseHeaders) {
                    if (this.headers.containsKey(h.getName())) {
                        ArrayList<String> list = this.reduplicateHeaders.get(h.getName());
                        if (list == null) {
                            list = new ArrayList();
                            String v = this.headers.get(h.getName());
                            list.add(v);
                        }
                        list.add(h.getValue());
                        this.reduplicateHeaders.put(h.getName(), list);
                        this.headers.put(h.getName(), null);
                        continue;
                    }
                    this.headers.put(h.getName(), h.getValue());
                }
            }
            this.parseResponseStatus(response);
            HttpEntity entity = response.getEntity();
            if (logger.isDebugEnabled()) {
                this.debugPostData(entity);
            }
            return entity;
        }
        catch (ClientProtocolException e) {
            logger.error((Object)"refetch failure.", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"refetch failure.", (Throwable)e);
        }
        return null;
    }

    private void genAddHttpHeader(HttpRequestBase http) {
        Set<Map.Entry<String, String>> entry = this.addHttpHeaders.entrySet();
        Iterator<Map.Entry<String, String>> iter = entry.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entryValue = iter.next();
            String name = entryValue.getKey();
            String value = entryValue.getValue();
            if (value == null) continue;
            http.setHeader(name, value);
        }
        Iterator<Map.Entry<String, ArrayList<String>>> iter2 = this.reduplicateAddHttpHeaders.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, ArrayList<String>> ent = iter2.next();
            String n = ent.getKey();
            ArrayList<String> v = ent.getValue();
            for (String s : v) {
                http.setHeader(n, s);
            }
        }
    }

    private String checkProtocol(String url) {
        try {
            if (url == null) {
                throw new RuntimeException("url is null");
            }
            String urlLowerCase = url.toLowerCase();
            if (urlLowerCase.startsWith("http://") || urlLowerCase.startsWith("https://")) {
                return url;
            }
            return "http://" + url;
        }
        catch (Exception exception) {
            return url;
        }
    }

    public String fetch(String url) {
        try {
            Header[] responseHeaders;
            url = this.checkProtocol(url);
            this.http = this.choiceHttpMethod(this.method, url);
            this.genHttpHeader(this.http, url);
            this.genAddHttpHeader(this.http);
            if (this.isPost) {
                this.genPostRequest(this.http);
            }
            if (logger.isDebugEnabled()) {
                this.debugRequestHeader(this.http);
            }
            HttpResponse response = this.httpclient.execute((HttpUriRequest)this.http);
            this.parseResponseStatus(response);
            for (Header h : responseHeaders = response.getAllHeaders()) {
                if (this.headers.containsKey(h.getName())) {
                    ArrayList<String> list = this.reduplicateHeaders.get(h.getName());
                    if (list == null) {
                        list = new ArrayList();
                        String v = this.headers.get(h.getName());
                        list.add(v);
                    }
                    list.add(h.getValue());
                    this.reduplicateHeaders.put(h.getName(), list);
                    this.headers.put(h.getName(), null);
                } else {
                    this.headers.put(h.getName(), h.getValue());
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(h.getName() + ":" + h.getValue()));
            }
            HttpEntity entity = null;
            if (this.isAllowRedirect) {
                String redirect1 = this.headers.get("Location");
                String redirect2 = this.headers.get("location");
                entity = null != redirect1 && !"".equals(redirect1) ? this.reFetch(redirect1) : (null != redirect2 && !"".equals(redirect2) ? this.reFetch(this.headers.get("location")) : response.getEntity());
            } else {
                entity = response.getEntity();
            }
            this.body = EntityUtils.toString((HttpEntity)entity);
            return this.body;
        }
        catch (ParseException e) {
            logger.error((Object)"fetch failure.", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"fetch failure.", (Throwable)e);
        }
        return "";
    }

    private void genHttpHeader(HttpRequestBase http, String url) {
        http.setHeader("FetchUrl", url);
        http.setHeader("AccessKey", this.accessKey);
        String timeStamp = Long.toString(System.currentTimeMillis() / 1000L);
        http.setHeader("TimeStamp", timeStamp);
        String content = "FetchUrl" + url + "TimeStamp" + timeStamp + "AccessKey" + this.accessKey;
        String signature = FetchurlUtil.calcSignature(content, this.secretKey);
        http.setHeader("Signature", signature);
        http.setHeader("User-Agent", "SAE Online Platform");
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setHttpAuth(String username, String password) {
        String content = username + ":" + password;
        String encodeContent = FetchurlUtil.encodeBase64(content);
        this.addHttpHeaders.put("Authorization", "Basic " + encodeContent);
    }

    public void setCookie(String name, String value) {
        String cookieValue = name + "=" + value + ";";
        if (!this.addHttpHeaders.containsKey(name)) {
            this.addHttpHeaders.put("Cookie", cookieValue);
        } else {
            ArrayList<String> values = this.reduplicateAddHttpHeaders.get(name);
            if (values == null) {
                values = new ArrayList();
                String v = this.addHttpHeaders.get("Cookie");
                values.add(v);
            }
            values.add(value);
            this.reduplicateAddHttpHeaders.put(name, values);
            this.addHttpHeaders.put(name, null);
        }
    }

    public void setCookies(Map<String, String> maps) {
        Set<Map.Entry<String, String>> entry = maps.entrySet();
        Iterator<Map.Entry<String, String>> iter = entry.iterator();
        StringBuilder cookieResult = new StringBuilder();
        while (iter.hasNext()) {
            Map.Entry<String, String> value = iter.next();
            String cookieName = value.getKey();
            String cookieValue = value.getValue();
            cookieResult.append(cookieName).append(":").append(cookieValue).append(";");
        }
        if (cookieResult.length() > 0) {
            cookieResult.deleteCharAt(cookieResult.length() - 1);
        }
        this.setCookie("Cookie", cookieResult.toString());
    }

    public void setHeader(String name, String value) {
        String trimName = name.trim();
        if (!this.checkIsForbid(trimName)) {
            if (!this.addHttpHeaders.containsKey(name)) {
                this.addHttpHeaders.put(name, value);
            } else {
                ArrayList<String> values = this.reduplicateAddHttpHeaders.get(name);
                if (values == null) {
                    values = new ArrayList();
                    String v = this.addHttpHeaders.get(name);
                    values.add(v);
                }
                values.add(value);
                this.reduplicateAddHttpHeaders.put(name, values);
                this.addHttpHeaders.put(name, null);
            }
        }
    }

    private boolean checkIsForbid(String header) {
        String lowerCase = header.toLowerCase();
        boolean isForbid = this.forbidHead.contains(lowerCase);
        return isForbid;
    }

    public void setReadTimeout(int timeout) {
        this.addHttpHeaders.put("ReadTimeout", Integer.toString(timeout));
    }

    public void setSendTimeout(int timeout) {
        this.addHttpHeaders.put("HEAD_SENDTIMEOUT", Integer.toString(timeout));
    }

    public void setAllowTrunc(boolean allow) {
        this.addHttpHeaders.put("AllowTruncated", Boolean.toString(allow));
        this.isTrunacated = allow;
    }

    public void setAllowRedirect(boolean allow) {
        this.addHttpHeaders.put("redirect", Boolean.toString(allow));
        this.isAllowRedirect = allow;
    }

    public Map<String, String> responseHeaders() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            if (entry.getValue() == null) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public Map<String, ArrayList<String>> responseReduplicateHeaders() {
        return new HashMap<String, ArrayList<String>>(this.reduplicateHeaders);
    }

    @Deprecated
    public String responseCookies() {
        String value = this.headers.get("Set-Cookie");
        if (value == null) {
            ArrayList<String> cookies = this.reduplicateHeaders.get("Set-Cookie");
            StringBuilder sb = new StringBuilder();
            for (String s : cookies) {
                sb.append(s).append('\t');
            }
            sb = sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        return value;
    }

    public String[] responseCookieArray() {
        ArrayList<String> cookies = this.reduplicateHeaders.get("Set-Cookie");
        String[] arr = new String[cookies.size()];
        for (int i = 0; i < cookies.size(); ++i) {
            arr[i] = cookies.get(i);
        }
        return arr;
    }

    public int getHttpCode() {
        return this.httpStatusCode;
    }

    public int getErrno() {
        return this.saeStatusCode;
    }

    public String getErrmsg() {
        return this.statusMsg;
    }

    public void clean() {
        this.headers.clear();
        this.reduplicateHeaders.clear();
        this.addHttpHeaders.clear();
        this.reduplicateAddHttpHeaders.clear();
        this.isPost = false;
        this.postMap.clear();
        this.saeStatusCode = 0;
        this.httpStatusCode = 200;
    }

    public String body() {
        return this.body;
    }

    public void setPostData(Map<String, String> maps) {
        this.setPostData(maps, this.characterEncode);
    }

    public void setPostData(Map<String, String> maps, String characterEncode) {
        this.setMethod(POST);
        this.postMap = maps;
        this.isPost = true;
        this.characterEncode = characterEncode;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("post data:" + maps));
        }
    }

    public void setPostData(BinaryData data) {
        this.binaryList.add(data);
        this.setMethod(POST);
        this.isPost = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("post data:" + data));
        }
    }
}

