/*
 * Decompiled with CFR 0.152.
 */
package com.sina.sae.kvdb;

import com.sina.sae.kvdb.DBBase;
import com.sina.sae.kvdb.TransformUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class KVDao
extends DBBase {
    private static final String CREATE_TABLE_SQL = "create table sae_kv( kv_key varchar(200) not null PRIMARY KEY, kv_value BLOB, kv_type int )";
    private static final String DROP_TABLE_SQL = "drop table sae_kv ";
    private static Logger logger = Logger.getLogger((String)KVDao.class.getName());
    private static KVDao kvDao;

    private KVDao() {
        try {
            this.initDB();
            this.createTable();
        }
        catch (Exception e) {
            logger.error((Object)("\u521d\u59cb\u5316\u6570\u636e\u5e93\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5JavaDB\u73af\u5883\u662f\u5426\u6b63\u786e\uff01#" + e.getMessage()));
        }
    }

    protected static KVDao getInstance() {
        return kvDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTable() {
        Connection conn;
        block5: {
            conn = null;
            if (!this.checkTableExist("SAE_KV")) break block5;
            logger.debug((Object)"#\u8bd5\u56fe\u521b\u5efa\u5df2\u7ecf\u5b58\u5728\u7684\u8868#\u5df2\u963b\u6b62\u8be5\u64cd\u4f5c#");
            this.closeConnection(conn);
            return;
        }
        try {
            conn = this.getConnection();
            this.executeUpdate(conn, CREATE_TABLE_SQL);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("\u521b\u5efakv\u8868\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef!#" + e.getMessage()));
            }
            catch (Throwable throwable) {
                this.closeConnection(conn);
                throw throwable;
            }
            this.closeConnection(conn);
        }
        this.closeConnection(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropTable() {
        Connection conn;
        block5: {
            conn = null;
            if (this.checkTableExist("sae_kv")) break block5;
            logger.debug((Object)"#\u8bd5\u56fe\u5220\u9664\u4e0d\u5b58\u5728\u7684\u8868#");
            this.closeConnection(conn);
            return;
        }
        try {
            conn = this.getConnection();
            this.executeUpdate(conn, DROP_TABLE_SQL);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("\u5220\u9664kv\u8868\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef!#" + e.getMessage()));
            }
            catch (Throwable throwable) {
                this.closeConnection(conn);
                throw throwable;
            }
            this.closeConnection(conn);
        }
        this.closeConnection(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkKeyExist(String key) {
        boolean flag = false;
        Connection conn = null;
        String sql = "select count(*) from sae_kv where kv_key =? ";
        try {
            conn = this.getConnection();
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, key);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (rs.getInt(1) == 0) continue;
                flag = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)("\u67e5\u8be2kv\u8868\u4e2d\u662f\u5426\u5b58\u5728\u6307\u5b9akey\u503c(" + key + ") \u65f6\u51fa\u73b0\u9519\u8bef!#" + e.getMessage()));
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConnection(conn);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer getTotalCount() {
        Connection conn = null;
        int count = 0;
        String sql = "select count(*) from sae_kv  ";
        try {
            conn = this.getConnection();
            PreparedStatement ps = conn.prepareStatement(sql);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                count = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("\u67e5\u8be2kv\u8868\u5305\u542bkey\u4e2a\u6570\u65f6\u51fa\u73b0\u9519\u8bef!#" + e.getMessage()));
            Integer n = -1;
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean set(String key, byte[] value, int type) {
        boolean flag = false;
        Connection conn = null;
        String sql = "insert into sae_kv values(?,?,?)";
        try {
            conn = this.getConnection();
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, key);
            ps.setBytes(2, value);
            ps.setInt(3, type);
            if (ps.executeUpdate() > 0) {
                flag = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)("\u5b58\u50a8key\u4e3a\uff1a" + key + "\u7684\u6570\u636e\u65f6\u5019\u51fa\u73b0\u9519\u8bef!#" + e.getMessage()));
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConnection(conn);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean replace(String key, byte[] value, int type) {
        boolean flag = false;
        Connection conn = null;
        String sql = "update sae_kv set kv_value=? , kv_type=? where kv_key=?";
        try {
            conn = this.getConnection();
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setBytes(1, value);
            ps.setInt(2, type);
            ps.setString(3, key);
            if (ps.executeUpdate() > 0) {
                flag = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)("\u66ff\u6362key\u4e3a:" + key + " \u65f6\u51fa\u73b0\u9519\u8bef!#" + e.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConnection(conn);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T get(String key) {
        Connection conn = null;
        byte[] value = null;
        int type = 0;
        String sql = "select kv_value,kv_type from sae_kv where kv_key=? ";
        try {
            conn = this.getConnection();
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, key);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                value = rs.getBytes(1);
                type = rs.getInt(2);
            }
            if (null != value) {
                Object t = TransformUtil.toConcreteType(value, type);
                return t;
            }
            T t = null;
            return t;
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6key\u503c\u4e3a\uff1a" + key + " \u65f6\u51fa\u73b0\u9519\u8bef!#" + e.getMessage()));
            T t = null;
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> getMulti(String[] keys) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Connection conn = null;
        ResultSet rs = null;
        String sql = "select kv_value,kv_type from sae_kv where kv_key=? ";
        try {
            conn = this.getConnection();
            PreparedStatement ps = conn.prepareStatement(sql);
            int type = 0;
            byte[] value = null;
            for (int i = 0; i < keys.length; ++i) {
                ps.setString(1, keys[i]);
                rs = ps.executeQuery();
                while (rs.next()) {
                    value = rs.getBytes(1);
                    type = rs.getInt(2);
                }
                if (value != null) {
                    map.put(keys[i], TransformUtil.toConcreteType(value, type));
                    continue;
                }
                logger.error((Object)("\u6279\u91cf\u83b7\u53d6\u6570\u636e\u8fc7\u7a0b\u4e2d,\u5728\u83b7\u53d6key\u503c\u4e3a" + keys[i] + "\u65f6\u51fa\u73b0\u9519\u8bef!#"));
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u6279\u91cf\u83b7\u53d6\u6570\u636e\u65f6\u51fa\u73b0\u9519\u8bef!#" + e.getMessage()));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            return hashMap;
        }
        finally {
            this.closeConnection(conn);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> getPkr(String prefixKey, int queryCount, boolean isContainValue, String compareKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Connection conn = null;
        ResultSet rs = null;
        StringBuilder sql = new StringBuilder("select kv_key,kv_value,kv_type from sae_kv where kv_key like ? ");
        if (null != compareKey) {
            sql.append("and kv_key>?");
        }
        try {
            conn = this.getConnection();
            PreparedStatement ps = conn.prepareStatement(sql.toString());
            ps.setString(1, prefixKey + "%");
            if (null != compareKey) {
                ps.setString(2, compareKey);
            }
            rs = ps.executeQuery();
            String key = null;
            byte[] value = null;
            int type = 0;
            int count = 1;
            while (rs.next()) {
                if (queryCount < count++) {
                    break;
                }
                key = rs.getString(1);
                if (isContainValue) {
                    value = rs.getBytes(2);
                }
                type = rs.getInt(3);
                if (key == null) continue;
                map.put(key, TransformUtil.toConcreteType(value, type));
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u524d\u7f00\u53d6\u6570\u636e\u65f6\u51fa\u73b0\u9519\u8bef!#" + e.getMessage()));
            Map<String, Object> map2 = null;
            return map2;
        }
        finally {
            this.closeConnection(conn);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> rgetCommand(String startKey, String endKey, boolean isContainStartVlaue, boolean isContainEndValue, int queryCount) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Connection conn = null;
        ResultSet rs = null;
        StringBuilder sql = new StringBuilder("select kv_key,kv_value,kv_type from sae_kv where kv_key>=? and kv_key<=?  ");
        try {
            conn = this.getConnection();
            PreparedStatement ps = conn.prepareStatement(sql.toString());
            ps.setString(1, startKey);
            ps.setString(2, endKey);
            rs = ps.executeQuery();
            String key = null;
            byte[] value = null;
            int type = 0;
            int count = 1;
            while (rs.next() && queryCount >= count) {
                if (!isContainStartVlaue & count++ == 1) continue;
                key = rs.getString(1);
                value = rs.getBytes(2);
                type = rs.getInt(3);
                if (key == null || value == null) continue;
                map.put(key, TransformUtil.toConcreteType(value, type));
            }
            if (null != map && !isContainEndValue) {
                map.remove(key);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u524d\u7f00\u53d6\u6570\u636e\u65f6\u51fa\u73b0\u9519\u8bef!#" + e.getMessage()));
            Map<String, Object> map2 = null;
            return map2;
        }
        finally {
            this.closeConnection(conn);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean delete(String key) {
        boolean flag = false;
        Connection conn = null;
        String sql = "delete from  sae_kv where kv_key = ?";
        try {
            conn = this.getConnection();
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, key);
            if (ps.executeUpdate() > 0) {
                flag = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)("\u5220\u9664key\u4e3a\uff1a" + key + "\u7684\u6570\u636e\u65f6\u5019\u51fa\u73b0\u9519\u8bef!#" + e.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConnection(conn);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer rdelCommand(String startKey, String endKey, boolean isContainStartVlaue, boolean isContainEndValue, int deleteCount) {
        int count = 0;
        Connection conn = null;
        StringBuilder sql = new StringBuilder("delete from sae_kv where kv_key>? and kv_key<?  ");
        try {
            conn = this.getConnection();
            PreparedStatement ps = conn.prepareStatement(sql.toString());
            ps.setString(1, startKey);
            ps.setString(2, endKey);
            count = ps.executeUpdate();
            if (isContainStartVlaue && this.delete(startKey)) {
                ++count;
            }
            if (isContainEndValue && this.delete(endKey)) {
                ++count;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u8303\u56f4\u5220\u9664\u65f6\u51fa\u73b0\u9519\u8bef!#" + e.getMessage()));
            Integer n = -1;
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
        return count;
    }

    static {
        if (null == kvDao) {
            logger.info((Object)"#\u521b\u5efaKVDao\u5bf9\u8c61#");
            kvDao = new KVDao();
        }
    }
}

