/*
 * Decompiled with CFR 0.152.
 */
package com.sina.sae.kvdb;

import com.sina.sae.exception.NotInitializeException;
import com.sina.sae.kvdb.KVDao;
import com.sina.sae.kvdb.SaeKVUtil;
import com.sina.sae.kvdb.TransformUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SaeKV {
    private static Logger log = Logger.getLogger((String)SaeKV.class.getName());
    private static final int DEFAULT_PKRGET_QUERY_COUNT = 10;
    private static final int DEFAULT_RGET_QUERY_COUNT = 10;
    private static final int MAX_RGET_QUERY_COUNT = 512;
    private static final int DEFAULT_RDEL_DELETE_COUNT = 10;
    private boolean initialized = false;
    private int errCode;
    private String errMsg;

    public void init() {
        this.initialized = true;
    }

    public boolean delete(String key) {
        return this.delete(key, null);
    }

    public boolean delete(String key, Date expiry) {
        if (!this.initialized) {
            throw new NotInitializeException();
        }
        if (key == null) {
            log.error((Object)"null value for key passed to delete()");
            return false;
        }
        try {
            key = TransformUtil.encodeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"failed to sanitize your key!", (Throwable)e);
            return false;
        }
        return KVDao.getInstance().delete(key);
    }

    public boolean set(String key, long value) {
        return this.set("set", key, value, null, 1);
    }

    public boolean set(String key, double value) {
        return this.set("set", key, value, null, 2);
    }

    public boolean set(String key, boolean value) {
        return this.set("set", key, value, null, 3);
    }

    public boolean set(String key, byte[] value) {
        return this.set("set", key, value, null, 0);
    }

    public boolean set(String key, long value, long expiry) {
        return this.set("set", key, value, null, 1);
    }

    public boolean set(String key, double value, long expiry) {
        return this.set("set", key, value, null, 2);
    }

    public boolean set(String key, boolean value, long expiry) {
        return this.set("set", key, value, null, 3);
    }

    public boolean set(String key, byte[] value, long expiry) {
        return this.set("set", key, value, null, 0);
    }

    private boolean set(String cmdname, String key, Object value, Date expiry, int type) {
        block13: {
            if (!this.initialized) {
                throw new NotInitializeException();
            }
            if (cmdname == null || cmdname.trim().equals("") || key == null) {
                log.error((Object)"key is null or cmd is null/empty for set()");
                return false;
            }
            try {
                key = this.sanitizeKey(key);
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"failed to sanitize your key!", (Throwable)e);
                return false;
            }
            if (value == null) {
                log.error((Object)"trying to store a null value to cache");
                return false;
            }
            byte[] val = null;
            try {
                val = SaeKVUtil.serializable(value);
            }
            catch (IOException e1) {
                log.error((Object)("++++ exception thrown while change object to bytes on set" + e1.getMessage()));
            }
            try {
                if (val == null) break block13;
                boolean keyExist = KVDao.getInstance().checkKeyExist(key);
                if (cmdname.equals("set")) {
                    if (keyExist) {
                        return KVDao.getInstance().replace(key, val, type);
                    }
                    return KVDao.getInstance().set(key, val, type);
                }
                if (cmdname.equals("replace")) {
                    return KVDao.getInstance().replace(key, val, type);
                }
                if (!cmdname.equals("add")) break block13;
                if (keyExist) {
                    log.error((Object)"trying to use add method  store a exist key  to cache");
                    break block13;
                }
                return KVDao.getInstance().set(key, val, type);
            }
            catch (Exception e) {
                log.error((Object)"++++ exception thrown while writing bytes to server on set");
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public <T> T get(String key) {
        if (!this.initialized) {
            throw new NotInitializeException();
        }
        if (key == null) {
            log.error((Object)"key is null.");
            return null;
        }
        try {
            key = TransformUtil.encodeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"encode key failure.", (Throwable)e);
            return null;
        }
        return KVDao.getInstance().get(key);
    }

    public Map<String, Object> getMulti(String[] keys) {
        if (keys == null || keys.length == 0) {
            log.error((Object)"missing keys for getMulti()");
            return new HashMap<String, Object>();
        }
        return KVDao.getInstance().getMulti(keys);
    }

    public Map<String, Object> pkrget(String prefixKey, String compareKey) {
        return this.pkrget(prefixKey, 10, true, compareKey);
    }

    public Map<String, Object> pkrget(String prefixKey, int queryCount, String compareKey) {
        return this.pkrget(prefixKey, queryCount, true, compareKey);
    }

    public Map<String, Object> pkrget(String prefixKey, int queryCount, boolean isContainValue, String compareKey) {
        if (!this.initialized) {
            throw new NotInitializeException();
        }
        if (prefixKey == null) {
            log.error((Object)"key is null for pkrget()");
            return null;
        }
        try {
            prefixKey = this.sanitizeKey(prefixKey);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"failed to sanitize your key!", (Throwable)e);
            return null;
        }
        return KVDao.getInstance().getPkr(prefixKey, queryCount, isContainValue, compareKey);
    }

    public Map<String, Object> rget(String startKey, String endKey) {
        return this.rget(startKey, endKey, true, true, 10);
    }

    public Map<String, Object> rget(String startKey, String endKey, boolean isContainStartVlaue, boolean isContainEndValue) {
        return this.rget(startKey, endKey, isContainStartVlaue, isContainEndValue, 10);
    }

    public Map<String, Object> rget(String startKey, String endKey, int queryCount) {
        return this.rget(startKey, endKey, true, true, queryCount);
    }

    public Map<String, Object> rget(String startKey, String endKey, boolean isContainStartVlaue, boolean isContainEndValue, int queryCount) {
        if (!this.initialized) {
            throw new NotInitializeException();
        }
        if (startKey == null) {
            log.error((Object)"startKey is null for rget()");
            return new HashMap<String, Object>();
        }
        if (endKey == null) {
            log.error((Object)"endKey is null for rget()");
            return new HashMap<String, Object>();
        }
        if (queryCount > 512) {
            queryCount = 512;
        }
        try {
            startKey = TransformUtil.encodeKey(startKey);
            endKey = TransformUtil.encodeKey(endKey);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"encode key failure.", (Throwable)e);
            return new HashMap<String, Object>();
        }
        return KVDao.getInstance().rgetCommand(startKey, endKey, isContainStartVlaue, isContainEndValue, queryCount);
    }

    public boolean rdel(String startKey, String endKey) {
        return this.rdel(startKey, endKey, true, true, 10);
    }

    public boolean rdel(String startKey, String endKey, boolean isContainStartVlaue, boolean isContainEndValue) {
        return this.rdel(startKey, endKey, isContainStartVlaue, isContainEndValue, 10);
    }

    public boolean rdel(String startKey, String endKey, int deleteCount) {
        return this.rdel(startKey, endKey, true, true, deleteCount);
    }

    public boolean rdel(String startKey, String endKey, boolean isContainStartVlaue, boolean isContainEndValue, int deleteCount) {
        return this.rdelCommand(startKey, endKey, isContainStartVlaue, isContainEndValue, deleteCount);
    }

    private boolean rdelCommand(String startKey, String endKey, boolean isContainStartVlaue, boolean isContainEndValue, int deleteCount) {
        if (startKey == null) {
            log.error((Object)"startKey is null for rdel()");
            return false;
        }
        if (endKey == null) {
            log.error((Object)"endKey is null for rdel()");
            return false;
        }
        try {
            startKey = this.sanitizeKey(startKey);
            endKey = this.sanitizeKey(endKey);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"failed to sanitize your key!", (Throwable)e);
            return false;
        }
        int flag = KVDao.getInstance().rdelCommand(startKey, endKey, isContainStartVlaue, isContainEndValue, deleteCount);
        if (flag != -1) {
            log.info((Object)("#\u5220\u9664" + flag + "\u6761\u6570\u636e#"));
            return true;
        }
        return false;
    }

    public Map<String, Long> getInfo() {
        if (!this.initialized) {
            throw new NotInitializeException();
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        return map;
    }

    private String sanitizeKey(String key) throws UnsupportedEncodingException {
        return URLEncoder.encode(key, "UTF-8");
    }

    public void setOptions(String option) {
    }

    public int getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }
}

