/*
 * Decompiled with CFR 0.152.
 */
package com.sina.sae.kvdb;

import com.sina.sae.exception.BanCallException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;

public class SaeKVUtil {
    private SaeKVUtil() {
        throw new BanCallException("can not invoke SaeKVUtil constructor.");
    }

    public static long byteToLong(byte value) {
        long longValue = (long)value & 0xFFL;
        return longValue;
    }

    public static long shortToLong(short value) {
        long longValue = (long)value & 0xFFFFL;
        return longValue;
    }

    public static long charToLong(char value) {
        long longValue = (long)value & 0xFFFFL;
        return longValue;
    }

    public static long intToLong(int value) {
        long longValue = (long)value & 0xFFFFFFFFL;
        return longValue;
    }

    public static byte longToByte(Object value) {
        if (!(value instanceof Long)) {
            return -1;
        }
        long newValue = (Long)value;
        byte byteValue = (byte)(newValue & 0xFFL);
        return byteValue;
    }

    public static short longToShort(Object value) {
        if (!(value instanceof Long)) {
            return -1;
        }
        long newValue = (Long)value;
        short shortValue = (short)(newValue & 0xFFFFL);
        return shortValue;
    }

    public static char longToChar(Object value) {
        if (!(value instanceof Long)) {
            return '\uffff';
        }
        long newValue = (Long)value;
        char charValue = (char)(newValue & 0xFFFFL);
        return charValue;
    }

    public static int longToInt(Object value) {
        if (!(value instanceof Long)) {
            return -1;
        }
        long newValue = (Long)value;
        int intValue = (int)(newValue & 0xFFFFFFFFFFFFFFFFL);
        return intValue;
    }

    public static <T> T deserializable(Object value) throws IOException, ClassNotFoundException {
        if (!(value instanceof byte[])) {
            return null;
        }
        byte[] buf = (byte[])value;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        DeserializableObject ois = new DeserializableObject(new ByteArrayInputStream(buf), loader);
        Object obj = ois.readObject();
        return (T)obj;
    }

    public static byte[] serializable(Object value) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        new ObjectOutputStream(bos).writeObject(value);
        return bos.toByteArray();
    }

    public static byte[] StringToByte(String value) {
        return value.getBytes();
    }

    public static String byteToString(byte[] value) {
        return new String(value);
    }

    public static String objToString(Object obj) {
        if (obj instanceof byte[]) {
            byte[] buf = (byte[])obj;
            return new String(buf);
        }
        return null;
    }

    private static class DeserializableObject
    extends ObjectInputStream {
        private ClassLoader loader;

        DeserializableObject(InputStream in, ClassLoader loader) throws IOException {
            super(in);
            this.loader = loader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return Class.forName(desc.getName(), true, this.loader);
        }
    }
}

