/*
 * Decompiled with CFR 0.152.
 */
package com.sina.sae.memcached;

import com.sina.sae.memcached.ConnectorPool;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.TreeMap;

public class ConsistentHash {
    private TreeMap<Long, ConnectorPool.Slot> ketamaNodes = new TreeMap();
    private int numReps = 16;

    public ConsistentHash(List<ConnectorPool.Slot> nodes) {
        for (ConnectorPool.Slot node : nodes) {
            for (int i = 0; i < this.numReps / 4; ++i) {
                byte[] digest = ConsistentHash.computeMd5(node.getName());
                for (int h = 0; h < 4; ++h) {
                    long m = ConsistentHash.hash(digest, h);
                    this.ketamaNodes.put(m, node);
                }
            }
        }
    }

    public ConnectorPool.Slot getPrimary(String key) {
        byte[] digest = ConsistentHash.computeMd5(key);
        ConnectorPool.Slot rv = this.getNodeForKey(ConsistentHash.hash(digest, 0));
        return rv;
    }

    private ConnectorPool.Slot getNodeForKey(long hash) {
        Long key = hash;
        if (!this.ketamaNodes.containsKey(key) && (key = this.ketamaNodes.ceilingKey(key)) == null) {
            key = this.ketamaNodes.firstKey();
        }
        ConnectorPool.Slot rv = this.ketamaNodes.get(key);
        return rv;
    }

    public static long hash(byte[] digest, int nTime) {
        long rv = (long)(digest[3 + nTime * 4] & 0xFF) << 24 | (long)(digest[2 + nTime * 4] & 0xFF) << 16 | (long)(digest[1 + nTime * 4] & 0xFF) << 8 | (long)(digest[0 + nTime * 4] & 0xFF);
        return rv & 0xFFFFFFFFL;
    }

    public static byte[] computeMd5(String key) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 not supported", e);
        }
        md5.reset();
        byte[] keyBytes = null;
        try {
            keyBytes = key.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unknown string :" + key, e);
        }
        md5.update(keyBytes);
        return md5.digest();
    }
}

