/*
 * Decompiled with CFR 0.152.
 */
package com.sina.sae.memcached;

import com.sina.sae.exception.NotInitializeException;
import com.sina.sae.memcached.ConnectorPool;
import com.sina.sae.memcached.TransformUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class SaeMemcache {
    private static final String STORED = "STORED";
    private static final String NOTSTORED = "NOT_STORED";
    private static final String ERROR = "ERROR";
    private static final String CLIENT_ERROR = "CLIENT_ERROR";
    private static final String VALUE = "VALUE";
    private static final String END = "END";
    private static final String DELETED = "DELETED";
    private static final String NOTFOUND = "NOT_FOUND";
    private static final String CRLF = "\r\n";
    private static final int COMPRESS_THREADHOLD = 1024;
    private static final Logger logger = Logger.getLogger((String)SaeMemcache.class.getName());
    private ConnectorPool pool = ConnectorPool.getInstance();
    private boolean initialized = false;

    public SaeMemcache() {
        this(new String[]{"localhost:11211"});
    }

    public SaeMemcache(String ip, int port) {
        this(new String[]{ip + ":" + port});
    }

    public SaeMemcache(String[] ips) {
        this.pool.initialize(ips);
    }

    public synchronized void init() {
        this.initialized = true;
    }

    public boolean add(String key, Object value) {
        return this.add(key, value, 0L);
    }

    public boolean add(String key, Object value, long expiry) {
        return this.storeVlaue("add", key, value, expiry);
    }

    public boolean replace(String key, Object value) {
        return this.replace(key, value, 0L);
    }

    public boolean replace(String key, Object value, long expiry) {
        return this.storeVlaue("replace", key, value, expiry);
    }

    public boolean set(String key, Object value) {
        return this.set(key, value, 0L);
    }

    public boolean set(String key, Object value, long expiry) {
        return this.storeVlaue("set", key, value, expiry);
    }

    public boolean delete(String key) {
        return this.delete(key, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String key, long expiry) {
        block21: {
            if (!this.initialized) {
                throw new NotInitializeException("please invoke init()");
            }
            if (key == null) {
                logger.error((Object)"key is null.");
                return false;
            }
            try {
                key = TransformUtil.encodeKey(key);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"encode key failure.", (Throwable)e);
                return false;
            }
            String command = "delete " + key;
            if (expiry >= 0L) {
                command = command + " " + expiry;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("command :" + command));
            }
            command = command + CRLF;
            ConnectorPool.Connector conn = this.pool.getConnector(key);
            try {
                String line;
                block20: {
                    conn.send(command.getBytes());
                    try {
                        line = conn.readLine();
                        if (DELETED.equals(line)) {
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)"delete key success.");
                            }
                            boolean bl = true;
                            return bl;
                        }
                        if (!NOTFOUND.equals(line)) break block20;
                    }
                    catch (IOException e) {
                        logger.error((Object)"execute delete failure.", (Throwable)e);
                        break block21;
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"not found key.");
                    }
                    boolean bl = false;
                    return bl;
                }
                if (ERROR.equals(line)) {
                    logger.warn((Object)"execute delete failure.");
                }
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
            finally {
                this.pool.RecoveryConnector(conn);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeVlaue(String command, String key, Object value, long expiry) {
        if (!this.initialized) {
            throw new NotInitializeException("please invoke init()");
        }
        if (command == null || command.trim().equals("") || key == null) {
            logger.error((Object)"key is null or cmd is null/empty");
            return false;
        }
        if (value == null) {
            logger.error((Object)"value is null");
            return false;
        }
        try {
            key = TransformUtil.encodeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"encode key failure.", (Throwable)e);
            return false;
        }
        if (expiry <= 0L) {
            expiry = 0L;
        }
        int flag = 0;
        byte[] content = null;
        flag = TransformUtil.getFlag(value);
        try {
            content = TransformUtil.toBytes(value);
        }
        catch (IOException ex) {
            logger.error((Object)"transformat type error.", (Throwable)ex);
            return false;
        }
        if (content == null) {
            logger.error((Object)"value is null");
            return false;
        }
        if (content.length > 1024) {
            try {
                content = TransformUtil.compress(content);
                flag = TransformUtil.setCompressFlag(flag);
            }
            catch (IOException e) {
                logger.error((Object)"compress failure.", (Throwable)e);
                return false;
            }
        }
        String cmd = String.format("%s %s %d %d %d", command, key, flag, expiry, content.length);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(command + ":" + cmd));
            logger.debug((Object)("content:" + Arrays.toString(content)));
        }
        cmd = cmd + CRLF;
        ConnectorPool.Connector connector = this.pool.getConnector(key);
        try {
            connector.send(cmd.getBytes());
            connector.send(content);
            connector.send(CRLF.getBytes());
            String line = null;
            try {
                line = connector.readLine();
            }
            catch (IOException e) {
                logger.error((Object)"read return content failure.", (Throwable)e);
                boolean bl = false;
                this.pool.RecoveryConnector(connector);
                return bl;
            }
            if (STORED.equals(line)) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("key " + key + " stored success."));
                }
                boolean bl = true;
                return bl;
            }
            if (NOTSTORED.equals(line)) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("key " + key + " not stored."));
                }
                boolean bl = false;
                return bl;
            }
            if (ERROR.equals(line)) {
                logger.warn((Object)("command " + command + " execute failure."));
                boolean bl = false;
                return bl;
            }
            if (line.startsWith(CLIENT_ERROR)) {
                logger.warn((Object)"client send data format error.");
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.RecoveryConnector(connector);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(String key) {
        if (!this.initialized) {
            throw new NotInitializeException("please invoke init()");
        }
        if (key == null) {
            logger.error((Object)"key is null.");
            return null;
        }
        try {
            key = TransformUtil.encodeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"encode key failure.", (Throwable)e);
            return null;
        }
        String command = "get " + key;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("get command :" + command));
        }
        command = command + CRLF;
        ConnectorPool.Connector conn = this.pool.getConnector(key);
        try {
            conn.send(command.getBytes());
            String line = conn.readLine();
            if (line.startsWith(VALUE)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("receive line:" + line));
                }
                String[] info = line.split(" ");
                int flag = Integer.parseInt(info[2]);
                int length = Integer.parseInt(info[3]);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("flag:" + flag));
                    logger.debug((Object)("data length:" + length));
                }
                byte[] buf = new byte[length];
                conn.read(buf);
                conn.readEOF();
                line = conn.readLine();
                if (END.equals(line)) {
                    logger.info((Object)"execute get command success.");
                }
                if (TransformUtil.isUseDecompress(flag)) {
                    flag = TransformUtil.setDeCompressFlag(flag);
                    buf = TransformUtil.deCompress(buf);
                }
                Object t = TransformUtil.toConcreteType(buf, flag);
                return t;
            }
            if (END.equals(line)) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"no key found.");
                }
                T t = null;
                return t;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.RecoveryConnector(conn);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incr(String key, long value) {
        if (!this.initialized) {
            throw new NotInitializeException("please invoke init()");
        }
        int number = -1;
        if (key == null) {
            logger.error((Object)"key is null.");
            return number;
        }
        try {
            key = TransformUtil.encodeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"encode key failure.", (Throwable)e);
            return number;
        }
        String command = "incr " + key + " " + value;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("get command :" + command));
        }
        command = command + CRLF;
        ConnectorPool.Connector conn = this.pool.getConnector(key);
        try {
            conn.send(command.getBytes());
            String line = conn.readLine();
            try {
                int n = number = Integer.parseInt(line);
                return n;
            }
            catch (NumberFormatException e) {
                try {
                    if (NOTFOUND.equals(line)) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("not found " + key));
                        }
                    } else if (ERROR.equals(line)) {
                        logger.warn((Object)"execute incr failure.");
                    }
                    this.pool.RecoveryConnector(conn);
                }
                catch (IOException e2) {
                    logger.error((Object)"execute incr failure.", (Throwable)e2);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.pool.RecoveryConnector(conn);
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decr(String key, long value) {
        if (!this.initialized) {
            throw new NotInitializeException("please invoke init()");
        }
        int number = -1;
        if (key == null) {
            logger.error((Object)"key is null.");
            return number;
        }
        try {
            key = TransformUtil.encodeKey(key);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"encode key failure.", (Throwable)e);
            return number;
        }
        String command = "decr " + key + " " + value;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("get command :" + command));
        }
        command = command + CRLF;
        ConnectorPool.Connector conn = this.pool.getConnector(key);
        try {
            conn.send(command.getBytes());
            String line = conn.readLine();
            try {
                int n = number = Integer.parseInt(line);
                return n;
            }
            catch (NumberFormatException e) {
                try {
                    if (NOTFOUND.equals(line)) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("not found " + key));
                        }
                    } else if (ERROR.equals(line)) {
                        logger.warn((Object)"execute decr failure.");
                    }
                    this.pool.RecoveryConnector(conn);
                }
                catch (IOException e2) {
                    logger.error((Object)"execute decr failure.", (Throwable)e2);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.pool.RecoveryConnector(conn);
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getMulti(String[] keys) {
        HashMap<String, Object> hashMap;
        List list;
        if (!this.initialized) {
            throw new NotInitializeException("please invoke init()");
        }
        if (keys == null) {
            logger.error((Object)"keys is null.");
            return new HashMap<String, Object>();
        }
        if (keys.length == 0) {
            return new HashMap<String, Object>();
        }
        HashMap<ConnectorPool.Connector, List> keysMapping = new HashMap<ConnectorPool.Connector, List>();
        for (String k : keys) {
            ConnectorPool.Connector newConnector;
            try {
                k = TransformUtil.encodeKey(k);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"encode key failure.", (Throwable)e);
                return null;
            }
            ConnectorPool.Connector conn = this.pool.getConnector(k);
            try {
                String ip = conn.getRemoteIp();
                int port = conn.getRemotePort();
                newConnector = new ConnectorPool.Connector(ip, Integer.toString(port));
            }
            finally {
                this.pool.RecoveryConnector(conn);
            }
            if (null == keysMapping.get(newConnector)) {
                ArrayList<String> list2 = new ArrayList<String>();
                list2.add(k);
                keysMapping.put(newConnector, list2);
                continue;
            }
            List list2 = (List)keysMapping.get(newConnector);
            list2.add(k);
            keysMapping.put(newConnector, list2);
        }
        int maxConnector = keysMapping.keySet().size();
        if (maxConnector > 4) {
            maxConnector = 4;
        } else if (maxConnector <= 0) {
            maxConnector = 4;
        }
        ExecutorService service = Executors.newFixedThreadPool(maxConnector);
        ArrayList<ConnectorPool.ConnectorFuture> futures = new ArrayList<ConnectorPool.ConnectorFuture>();
        for (ConnectorPool.Connector connector : keysMapping.keySet()) {
            list = (List)keysMapping.get(connector);
            StringBuilder getKeysCommand = new StringBuilder();
            getKeysCommand.append("get").append(" ");
            for (String string : list) {
                getKeysCommand.append(string).append(" ");
            }
            getKeysCommand = getKeysCommand.deleteCharAt(getKeysCommand.length() - 1);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("multi get :" + getKeysCommand.toString()));
            }
            getKeysCommand.append(CRLF);
            ConnectorPool.ConnectorFuture cf = new ConnectorPool.ConnectorFuture(connector, getKeysCommand.toString());
            futures.add(cf);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            list = service.invokeAll(futures);
            for (Future f : list) {
                Map map = (Map)f.get();
                result.putAll(map);
                f.cancel(true);
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)"interrput", (Throwable)e);
            Thread.currentThread().interrupt();
            hashMap = new HashMap();
            return hashMap;
        }
        catch (ExecutionException e) {
            logger.error((Object)"future get failure", (Throwable)e);
            hashMap = new HashMap<String, Object>();
            return hashMap;
        }
        finally {
            service.shutdown();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> stats() {
        if (!this.initialized) {
            throw new NotInitializeException("please invoke init()");
        }
        ConnectorPool.Connector[] connectors = this.pool.getAllConnector();
        ConnectorPool.Connector[] newConnectors = new ConnectorPool.Connector[connectors.length];
        for (int i = 0; i < newConnectors.length; ++i) {
            try {
                String ip = connectors[i].getRemoteIp();
                int port = connectors[i].getRemotePort();
                newConnectors[i] = new ConnectorPool.Connector(ip, Integer.toString(port));
                continue;
            }
            finally {
                this.pool.RecoveryConnector(connectors[i]);
                connectors[i] = null;
            }
        }
        ArrayList<Future> list = new ArrayList<Future>();
        int maxConnector = 4;
        ExecutorService service = Executors.newFixedThreadPool(maxConnector);
        for (int i = 0; i < newConnectors.length; ++i) {
            ConnectorPool.StatsFuture sf = new ConnectorPool.StatsFuture(newConnectors[i]);
            Future f = service.submit(sf);
            list.add(f);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Future f : list) {
            try {
                Map m = (Map)f.get();
                for (Map.Entry entry : m.entrySet()) {
                    Number v;
                    String key = (String)entry.getKey();
                    Object obj = entry.getValue();
                    if (obj instanceof Long) {
                        if (result.get(key) != null) {
                            long newV = (Long)obj;
                            long oldV = new Long((String)result.get(key));
                            v = new Long(newV + oldV);
                            result.put(key, ((Long)v).toString());
                            continue;
                        }
                        Long v2 = (Long)obj;
                        result.put(key, v2.toString());
                        continue;
                    }
                    if (obj instanceof Double) {
                        if (result.get(key) != null) {
                            double newV = (Double)obj;
                            double oldV = new Double((String)result.get(key));
                            v = new Double(newV + oldV);
                            result.put(key, ((Double)v).toString());
                            continue;
                        }
                        Double v3 = (Double)obj;
                        result.put(key, v3.toString());
                        continue;
                    }
                    if (!(obj instanceof String)) continue;
                    result.put(key, obj.toString());
                }
            }
            catch (InterruptedException e) {
                logger.error((Object)"interrupt.", (Throwable)e);
                Thread.currentThread().interrupt();
                return new HashMap<String, String>();
            }
            catch (ExecutionException e) {
                logger.error((Object)"execution exeption", (Throwable)e);
                return new HashMap<String, String>();
            }
        }
        service.shutdown();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushAll() {
        if (!this.initialized) {
            throw new NotInitializeException("please invoke init()");
        }
        ConnectorPool.Connector[] connectors = this.pool.getAllConnector();
        ConnectorPool.Connector[] newConnectors = new ConnectorPool.Connector[connectors.length];
        for (int i = 0; i < newConnectors.length; ++i) {
            try {
                String ip = connectors[i].getRemoteIp();
                int port = connectors[i].getRemotePort();
                newConnectors[i] = new ConnectorPool.Connector(ip, Integer.toString(port));
                continue;
            }
            finally {
                this.pool.RecoveryConnector(connectors[i]);
            }
        }
        int maxConnector = 4;
        ArrayList<Future> list = new ArrayList<Future>();
        ExecutorService service = Executors.newFixedThreadPool(maxConnector);
        for (int i = 0; i < newConnectors.length; ++i) {
            ConnectorPool.FlushFuture ff = new ConnectorPool.FlushFuture(newConnectors[i]);
            Future f = service.submit(ff);
            list.add(f);
        }
        boolean isSuccess = true;
        for (Future f : list) {
            try {
                Boolean b = (Boolean)f.get();
                if (b.booleanValue()) continue;
                logger.warn((Object)"flush_all failure.");
                isSuccess = false;
            }
            catch (InterruptedException e) {
                logger.error((Object)"interrupt.", (Throwable)e);
                Thread.currentThread().interrupt();
                return false;
            }
            catch (ExecutionException e) {
                logger.error((Object)"execution exeption", (Throwable)e);
                return false;
            }
        }
        service.shutdown();
        return isSuccess;
    }
}

