/*
 * Decompiled with CFR 0.152.
 */
package com.sina.sae.segment;

import com.sina.sae.segment.SaeSegmentItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SaeSegment {
    private static final Map<Integer, String> ERR_MSGS;
    private int errno = 0;
    private String errmsg = "OK";
    private final String defaultSplit;

    public SaeSegment() {
        this.defaultSplit = " ";
    }

    public SaeSegment(String defaultSplit) {
        this.defaultSplit = defaultSplit;
    }

    public List<SaeSegmentItem> segment(String context) {
        return this.segment(context, false, Encoding.UTF_8);
    }

    public List<SaeSegmentItem> segment(String context, boolean wordTag) {
        return this.segment(context, wordTag, Encoding.UTF_8);
    }

    public List<SaeSegmentItem> segment(String context, boolean wordTag, Encoding encoding) {
        String[] content;
        if (this.checkString(context)) {
            this.errno = -3;
            this.errmsg = ERR_MSGS.get(-3);
        }
        if ((content = this.splitString(context)) == null || content.length == 0) {
            return new ArrayList<SaeSegmentItem>();
        }
        List<SaeSegmentItem> list = this.generatSegmentItem(content, wordTag);
        this.errno = 0;
        this.errmsg = "OK";
        return list;
    }

    private List<SaeSegmentItem> generatSegmentItem(String[] content, boolean wordTag) {
        int tag = wordTag ? 1 : 0;
        ArrayList<SaeSegmentItem> list = new ArrayList<SaeSegmentItem>();
        for (int i = 0; i < content.length; ++i) {
            SaeSegmentItem item = new SaeSegmentItem(i, tag, content[i]);
            list.add(item);
        }
        return list;
    }

    private String[] splitString(String context) {
        return context.split(this.defaultSplit);
    }

    private boolean checkString(String context) {
        return context != null && !context.trim().equals("");
    }

    public int getErrno() {
        return this.errno;
    }

    public String getErrmsg() {
        return this.errmsg;
    }

    public static void main(String[] args) {
        SaeSegment s = new SaeSegment();
        List<SaeSegmentItem> list = s.segment("\u59da\u660e\u548c\u90ed\u656c\u660e");
        System.out.println(list);
    }

    static {
        HashMap<Integer, String> map = new HashMap<Integer, String>(8, 1.0f);
        map.put(-1, "word segmentation service internal error");
        map.put(-2, "parameters (word_tag, encoding) error.");
        map.put(-3, "context can not be empty");
        map.put(-4, "unknown error");
        map.put(607, "service is not enabled");
        ERR_MSGS = Collections.unmodifiableMap(map);
    }

    public static enum Encoding {
        GBK("GBK"),
        UTF_8("UTF-8"),
        UCS_2("UCS-2");

        private final String charset;

        private Encoding(String charset) {
            this.charset = charset;
        }

        public String getCharset() {
            return this.charset;
        }
    }
}

